/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.annotations.SerializedName;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.util.CollectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public sealed interface ModelChildren {
    public static final JsonDeserializer<ModelChildren> PARSER = (json, typeOfT, context) -> {
        if (json.isJsonPrimitive()) {
            return new ModelUUID(json.getAsString());
        }
        if (json.isJsonObject()) {
            return (ModelChildren)context.deserialize(json, ModelGroup.class);
        }
        throw new RuntimeException();
    };

    @NotNull
    default public BlueprintChildren toBlueprint(@NotNull @Unmodifiable Map<String, ModelElement> elementMap) {
        ModelChildren modelChildren = this;
        Objects.requireNonNull(modelChildren);
        ModelChildren modelChildren2 = modelChildren;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModelGroup.class, ModelUUID.class}, (Object)modelChildren2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ModelGroup modelGroup = (ModelGroup)modelChildren2;
                List<BlueprintChildren> child = CollectionUtil.mapToList(modelGroup.children(), c2 -> c2.toBlueprint(elementMap));
                List<BlueprintChildren.BlueprintElement> filtered = CollectionUtil.filterIsInstance(child, BlueprintChildren.BlueprintElement.class).toList();
                yield new BlueprintChildren.BlueprintGroup(BoneTagRegistry.parse(modelGroup.name()), modelGroup.origin(), modelGroup.rotation().invertXZ(), child, filtered.isEmpty() ? modelGroup.visibility() : filtered.stream().anyMatch(element -> element.element().visibility()));
            }
            case 1 -> {
                ModelUUID modelUUID = (ModelUUID)modelChildren2;
                yield new BlueprintChildren.BlueprintElement(Objects.requireNonNull(elementMap.get(modelUUID.uuid())));
            }
        };
    }

    public record ModelGroup(@NotNull String name, @Nullable Float3 origin, @Nullable Float3 rotation, @NotNull String uuid, @NotNull List<ModelChildren> children, @SerializedName(value="visibility") @Nullable Boolean _visibility) implements ModelChildren
    {
        @Nullable
        private final Float3 origin;
        @Nullable
        private final Float3 rotation;

        @NotNull
        public Float3 origin() {
            return this.origin != null ? this.origin : Float3.ZERO;
        }

        @NotNull
        public Float3 rotation() {
            return this.rotation != null ? this.rotation : Float3.ZERO;
        }

        public boolean visibility() {
            return !Boolean.FALSE.equals(this._visibility);
        }
    }

    public record ModelUUID(@NotNull String uuid) implements ModelChildren
    {
    }
}

