/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.annotations.SerializedName;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.ModelFace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModelElement(@NotNull String name, @Nullable Type type, @NotNull String uuid, @Nullable Float3 from, @Nullable Float3 to, float inflate, @Nullable Float3 rotation, @NotNull Float3 origin, @Nullable ModelFace faces, @SerializedName(value="visibility") @Nullable Boolean _visibility) {
    @Nullable
    private final Type type;
    @Nullable
    private final Float3 from;
    @Nullable
    private final Float3 to;
    @Nullable
    private final Float3 rotation;

    public float max() {
        Float3 f = this.from();
        Float3 t = this.to();
        float max = 0.0f;
        max = Math.max(max, Math.abs(f.x()));
        max = Math.max(max, Math.abs(f.y()));
        max = Math.max(max, Math.abs(f.z()));
        max = Math.max(max, Math.abs(t.x()));
        max = Math.max(max, Math.abs(t.y()));
        max = Math.max(max, Math.abs(t.z()));
        return max;
    }

    @NotNull
    public Float3 from() {
        return this.from != null ? this.from : Float3.ZERO;
    }

    @NotNull
    public Float3 to() {
        return this.to != null ? this.to : Float3.ZERO;
    }

    public boolean visibility() {
        return !Boolean.FALSE.equals(this._visibility);
    }

    @NotNull
    public Float3 rotation() {
        return this.rotation != null ? this.rotation : Float3.ZERO;
    }

    @NotNull
    public Type type() {
        return this.type != null ? this.type : Type.CUBE;
    }

    public boolean hasTexture() {
        return this.faces != null && this.faces.hasTexture();
    }

    public boolean isSupported() {
        return this.type() == Type.CUBE;
    }

    public static enum Type {
        CUBE,
        MESH;

    }
}

