/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.DummyTracker;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.CollectionUtil;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record ModelRenderer(@NotNull ModelBlueprint parent, @NotNull @Unmodifiable Map<BoneName, RendererGroup> rendererGroupMap, @NotNull @Unmodifiable Map<String, BlueprintAnimation> animationMap) {
    @Nullable
    public RendererGroup groupByTree(@NotNull BoneName name) {
        return ModelRenderer.groupByTree0(this.rendererGroupMap, name);
    }

    @Nullable
    private static RendererGroup groupByTree0(@NotNull Map<BoneName, RendererGroup> map, @NotNull BoneName name) {
        if (map.isEmpty()) {
            return null;
        }
        RendererGroup get = map.get(name);
        if (get != null) {
            return get;
        }
        return map.values().stream().map(g -> ModelRenderer.groupByTree0(g.getChildren(), name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    public Stream<RendererGroup> flatten() {
        return this.rendererGroupMap.values().stream().flatMap(RendererGroup::flatten);
    }

    @NotNull
    public @Unmodifiable Set<String> animations() {
        return this.animationMap.keySet();
    }

    @NotNull
    public Optional<BlueprintAnimation> animation(@NotNull String name) {
        return Optional.ofNullable(this.animationMap.get(name));
    }

    @NotNull
    public String name() {
        return this.parent.name();
    }

    @NotNull
    public DummyTracker create(@NotNull Location location) {
        return this.create(location, TrackerModifier.DEFAULT);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull TrackerModifier modifier) {
        return this.create(location, modifier, (DummyTracker t) -> {});
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
        RenderSource.Dummy source = RenderSource.of(location);
        return source.create(this.pipeline(source, modifier), modifier, preUpdateConsumer);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull OfflinePlayer player) {
        return this.create(location, player, TrackerModifier.DEFAULT);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull GameProfile profile) {
        return this.create(location, profile, TrackerModifier.DEFAULT);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull GameProfile profile, boolean slim) {
        return this.create(location, profile, slim, TrackerModifier.DEFAULT);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull OfflinePlayer player, @NotNull TrackerModifier modifier) {
        PlayerChannelHandler channel = BetterModel.plugin().playerManager().player(player.getUniqueId());
        return channel == null ? this.create(location, BetterModel.plugin().nms().profile(player), modifier) : this.create(location, channel.profile(), channel.isSlim(), modifier);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull GameProfile profile, @NotNull TrackerModifier modifier) {
        return this.create(location, profile, BetterModel.plugin().skinManager().isSlim(profile), modifier);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull GameProfile profile, boolean slim, @NotNull TrackerModifier modifier) {
        return this.create(location, profile, slim, modifier, (DummyTracker t) -> {});
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull GameProfile profile, boolean slim, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
        RenderSource.Dummy source = RenderSource.of(location, profile, slim);
        return source.create(this.pipeline(source, modifier), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity) {
        return this.create(entity, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity) {
        return this.getOrCreate(entity, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull OfflinePlayer player) {
        return this.create(entity, player, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull OfflinePlayer player, @NotNull TrackerModifier modifier) {
        PlayerChannelHandler channel = BetterModel.plugin().playerManager().player(player.getUniqueId());
        return channel == null ? this.create(entity, BetterModel.plugin().nms().profile(player), modifier) : this.create(entity, channel.profile(), channel.isSlim(), modifier);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull TrackerModifier modifier) {
        return this.create(entity, modifier, (EntityTracker t) -> {});
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        RenderSource.Entity source = RenderSource.of(entity);
        return source.create(this.pipeline(source, modifier), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull GameProfile profile, boolean slim) {
        return this.create(entity, profile, slim, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull GameProfile profile, @NotNull TrackerModifier modifier) {
        return this.create(entity, profile, BetterModel.plugin().skinManager().isSlim(profile), modifier);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull GameProfile profile, boolean slim, @NotNull TrackerModifier modifier) {
        return this.create(entity, profile, slim, modifier, (EntityTracker t) -> {});
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull GameProfile profile, boolean slim, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        RenderSource.Entity source = RenderSource.of(entity, profile, slim);
        return source.create(this.pipeline(source, modifier), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull TrackerModifier modifier) {
        return this.getOrCreate(entity, modifier, (EntityTracker t) -> {});
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        RenderSource.Entity source = RenderSource.of(entity);
        return source.getOrCreate(this.name(), () -> this.pipeline(source, modifier), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull OfflinePlayer player) {
        return this.getOrCreate(entity, player, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull OfflinePlayer player, @NotNull TrackerModifier modifier) {
        PlayerChannelHandler channel = BetterModel.plugin().playerManager().player(player.getUniqueId());
        return channel == null ? this.getOrCreate(entity, BetterModel.plugin().nms().profile(player), modifier) : this.getOrCreate(entity, channel.profile(), channel.isSlim(), modifier);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull GameProfile profile, boolean slim) {
        return this.getOrCreate(entity, profile, slim, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull GameProfile profile, @NotNull TrackerModifier modifier) {
        return this.getOrCreate(entity, profile, BetterModel.plugin().skinManager().isSlim(profile), modifier);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull GameProfile profile, boolean slim, @NotNull TrackerModifier modifier) {
        return this.getOrCreate(entity, profile, slim, modifier, t -> {});
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull GameProfile profile, boolean slim, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        RenderSource.Entity source = RenderSource.of(entity, profile, slim);
        return source.getOrCreate(this.name(), () -> this.pipeline(source, modifier), modifier, preUpdateConsumer);
    }

    @NotNull
    private RenderPipeline pipeline(@NotNull RenderSource<?> source, @NotNull TrackerModifier modifier) {
        return new RenderPipeline(this, source, CollectionUtil.mapValue(this.rendererGroupMap, value -> value.create(source, modifier)));
    }
}

