/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import java.io.File;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kr.toxicity.model.api.pack.PackByte;
import kr.toxicity.model.api.pack.PackMeta;
import kr.toxicity.model.api.pack.PackOverlay;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PackResult {
    private final PackMeta meta;
    private final File directory;
    private final Map<PackOverlay, Set<PackByte>> overlays = new EnumMap<PackOverlay, Set<PackByte>>(PackOverlay.class);
    private final Set<PackByte> assets = ConcurrentHashMap.newKeySet();
    private final Set<PackByte> assetsView = Collections.unmodifiableSet(this.assets);
    private final long creationTime = System.currentTimeMillis();
    private boolean frozen = false;
    private long time;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void set(@Nullable PackOverlay overlay, @NotNull PackByte packByte) {
        if (this.frozen) {
            throw new IllegalStateException("result is frozen.");
        }
        if (overlay == null) {
            this.assets.add(packByte);
            return;
        }
        Map<PackOverlay, Set<PackByte>> map = this.overlays;
        synchronized (map) {
            this.overlays.computeIfAbsent(overlay, o -> new HashSet()).add(packByte);
        }
    }

    public void freeze() {
        if (this.frozen) {
            throw new IllegalStateException("result is frozen.");
        }
        this.frozen = true;
        this.time = System.currentTimeMillis() - this.creationTime;
    }

    @NotNull
    public PackMeta meta() {
        return this.meta;
    }

    @Nullable
    public File directory() {
        return this.directory;
    }

    public int size() {
        return this.assets.size() + this.overlays.values().stream().mapToInt(Set::size).sum();
    }

    public long time() {
        return this.time;
    }

    @NotNull
    public @Unmodifiable Set<PackByte> overlays(@NotNull PackOverlay overlay) {
        Set<PackByte> get = this.overlays.get((Object)overlay);
        return get != null ? Collections.unmodifiableSet(get) : Collections.emptySet();
    }

    @NotNull
    public @Unmodifiable Set<PackByte> assets() {
        return this.assetsView;
    }

    @Generated
    public PackResult(PackMeta meta, File directory) {
        this.meta = meta;
        this.directory = directory;
    }
}

