/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.pack.PackAssets;
import kr.toxicity.model.api.pack.PackMeta;
import kr.toxicity.model.api.pack.PackOverlay;
import kr.toxicity.model.api.pack.PackPath;
import kr.toxicity.model.api.pack.PackResource;
import kr.toxicity.model.api.util.LogUtil;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackZipper {
    private static final PackPath PACK_ICON = new PackPath("pack.png");
    private final PackMeta.Builder metaBuilder = PackMeta.builder();
    private final Map<PackOverlay, PackAssets> overlayMap = new EnumMap<PackOverlay, PackAssets>(PackOverlay.class);

    @NotNull
    public static PackZipper zipper() {
        return new PackZipper();
    }

    @NotNull
    public PackAssets assets() {
        return this.getOrCreate(PackOverlay.DEFAULT);
    }

    @NotNull
    public PackAssets legacy() {
        return this.getOrCreate(PackOverlay.LEGACY);
    }

    @NotNull
    public PackAssets modern() {
        return this.getOrCreate(PackOverlay.MODERN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PackAssets getOrCreate(@NotNull PackOverlay overlay) {
        Map<PackOverlay, PackAssets> map = this.overlayMap;
        synchronized (map) {
            return this.overlayMap.computeIfAbsent(overlay, o -> new PackAssets(o.path(BetterModel.config().namespace()), (PackOverlay)((Object)o)));
        }
    }

    @NotNull
    public PackMeta.Builder metaBuilder() {
        return this.metaBuilder;
    }

    @ApiStatus.Internal
    @NotNull
    public BuildData build() {
        ArrayList<PackResource> resources = new ArrayList<PackResource>(this.size());
        for (Map.Entry<PackOverlay, PackAssets> entry : this.overlayMap.entrySet()) {
            PackOverlay overlay = entry.getKey();
            PackAssets value = entry.getValue();
            if (overlay.test() && value.dirty()) {
                resources.addAll(value.resourceMap.values());
                overlay.range().ifPresent(range -> this.metaBuilder.overlayEntry(new PackMeta.OverlayEntry((PackMeta.VersionRange)range, value.path.path())));
            }
            value.resourceMap.clear();
        }
        PackMeta meta = this.metaBuilder.build();
        resources.add(meta.toResource());
        PackResource icon = PackZipper.loadIcon();
        if (icon != null) {
            resources.add(icon);
        }
        return new BuildData(meta, resources);
    }

    public int size() {
        return this.overlayMap.values().stream().mapToInt(PackAssets::size).sum() + 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static PackResource loadIcon() {
        try (InputStream icon = BetterModel.plugin().getResource("icon.png");){
            if (icon == null) {
                PackResource packResource2 = null;
                return packResource2;
            }
            byte[] read = icon.readAllBytes();
            PackResource packResource = PackResource.of(PACK_ICON, read.length, () -> read);
            return packResource;
        }
        catch (IOException e) {
            LogUtil.handleException("Unable to get icon.png", e);
            return null;
        }
    }

    @Generated
    private PackZipper() {
    }

    public record BuildData(@NotNull PackMeta meta, @NotNull List<PackResource> resources) {
    }
}

