/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.script;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import kr.toxicity.model.api.script.ScriptSource;
import kr.toxicity.model.api.script.TimeScript;
import org.jetbrains.annotations.NotNull;

public interface AnimationScript
extends Consumer<ScriptSource> {
    public static final AnimationScript EMPTY = AnimationScript.of((ScriptSource s) -> {});

    @Override
    public void accept(@NotNull ScriptSource var1);

    public boolean isSync();

    @NotNull
    default public TimeScript time(float time) {
        return new TimeScript(time, this);
    }

    @NotNull
    public static AnimationScript of(@NotNull Consumer<ScriptSource> source) {
        return AnimationScript.of(false, source);
    }

    @NotNull
    public static AnimationScript of(final boolean isSync, final @NotNull Consumer<ScriptSource> source) {
        Objects.requireNonNull(source);
        return new AnimationScript(){

            @Override
            public boolean isSync() {
                return isSync;
            }

            @Override
            public void accept(@NotNull ScriptSource renderSource) {
                source.accept(renderSource);
            }
        };
    }

    @NotNull
    public static AnimationScript of(@NotNull List<AnimationScript> scriptList) {
        return switch (scriptList.size()) {
            case 0 -> EMPTY;
            case 1 -> scriptList.getFirst();
            default -> {
                boolean sync = false;
                Consumer<ScriptSource> consumer = trigger -> {};
                for (AnimationScript entityScript : scriptList) {
                    sync = sync || entityScript.isSync();
                    consumer = consumer.andThen(entityScript);
                }
                yield AnimationScript.of(sync, consumer);
            }
        };
    }
}

