/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import org.jetbrains.annotations.NotNull;

public record ModelRotation(float x, float y) {
    public static final ModelRotation EMPTY = new ModelRotation(0.0f, 0.0f);
    public static final ModelRotation INVALID = new ModelRotation(Float.MAX_VALUE, Float.MAX_VALUE);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelRotation)) return false;
        ModelRotation other = (ModelRotation)o;
        if (this.packedX() != other.packedX()) return false;
        if (this.packedY() != other.packedY()) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return (Byte.hashCode(this.packedX()) & 0xFF) << 8 | Byte.hashCode(this.packedY()) & 0xFF;
    }

    @NotNull
    public ModelRotation pitch() {
        return new ModelRotation(this.x, 0.0f);
    }

    @NotNull
    public ModelRotation yaw() {
        return new ModelRotation(0.0f, this.y);
    }

    public float radianX() {
        return this.x * ((float)Math.PI / 180);
    }

    public float radianY() {
        return this.y * ((float)Math.PI / 180);
    }

    public byte packedX() {
        return (byte)(this.x * 0.7111111f);
    }

    public byte packedY() {
        return (byte)(this.y * 0.7111111f);
    }
}

