/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kr.toxicity.model.api.animation.AnimationEventHandler;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTags;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.event.CloseTrackerEvent;
import kr.toxicity.model.api.event.ModelDespawnAtPlayerEvent;
import kr.toxicity.model.api.event.ModelSpawnAtPlayerEvent;
import kr.toxicity.model.api.event.PlayerHideTrackerEvent;
import kr.toxicity.model.api.event.PlayerPerAnimationEndEvent;
import kr.toxicity.model.api.event.PlayerPerAnimationStartEvent;
import kr.toxicity.model.api.event.PlayerShowTrackerEvent;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.ModelNametag;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.ModelRotator;
import kr.toxicity.model.api.tracker.ModelScaler;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.tracker.TrackerUpdateAction;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.LogUtil;
import kr.toxicity.model.api.util.function.BonePredicate;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class Tracker
implements AutoCloseable {
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2, new ThreadFactory(){
        private final AtomicInteger integer = new AtomicInteger();

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread thread2 = new Thread(r);
            thread2.setDaemon(true);
            thread2.setName("BetterModel-Worker-" + this.integer.getAndIncrement());
            thread2.setUncaughtExceptionHandler((t, e) -> LogUtil.handleException("Exception has occurred in " + t.getName(), e));
            return thread2;
        }
    });
    public static final int TRACKER_TICK_INTERVAL = 10;
    public static final int MINECRAFT_TICK_MULTIPLIER = 5;
    protected final RenderPipeline pipeline;
    private volatile ScheduledFuture<?> task;
    private long frame = 0L;
    private final Queue<Runnable> queuedTask = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicBoolean tickPause = new AtomicBoolean();
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicBoolean readyForForceUpdate = new AtomicBoolean();
    private final AtomicBoolean forRemoval = new AtomicBoolean();
    protected final TrackerModifier modifier;
    private final Runnable updater;
    private final BundlerSet bundlerSet;
    protected ModelRotator rotator = ModelRotator.YAW;
    protected ModelScaler scaler = ModelScaler.entity();
    private Supplier<ModelRotation> rotationSupplier = () -> ModelRotation.EMPTY;
    private BiConsumer<Tracker, CloseReason> closeEventHandler = (t, r) -> EventUtil.call(new CloseTrackerEvent((Tracker)t, (CloseReason)((Object)r)));
    private ScheduledPacketHandler handler = (t, s) -> {
        if (!this.tickPause.get()) {
            t.pipeline.tick(s.getViewBundler());
        }
    };
    private BiConsumer<Tracker, Player> perPlayerHandler = null;

    public Tracker(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier) {
        this.pipeline = pipeline;
        this.modifier = modifier;
        this.bundlerSet = new BundlerSet();
        this.updater = () -> {
            boolean isMinecraftTickTime;
            boolean bl = isMinecraftTickTime = this.frame % 5L == 0L;
            if (isMinecraftTickTime) {
                Runnable task;
                while ((task = this.queuedTask.poll()) != null) {
                    task.run();
                }
            }
            this.handler.handle(this, this.bundlerSet);
            this.bundlerSet.send();
        };
        if (modifier.sightTrace()) {
            pipeline.viewFilter(p -> EntityUtil.canSee(p.getEyeLocation(), this.location()));
        }
        this.frame((t, s) -> {
            if (this.readyForForceUpdate.compareAndSet(true, false)) {
                t.pipeline.iterateTree(b -> b.forceUpdate(s.dataBundler));
            }
        });
        this.tick((t, s) -> pipeline.rotate(t.rotation(), s.tickBundler));
        this.tick((t, s) -> {
            BiConsumer<Tracker, Player> perPlayer = this.perPlayerHandler;
            if (perPlayer != null) {
                pipeline.nonHidePlayer().forEach(p -> perPlayer.accept(t, (Player)p));
            }
        });
        pipeline.spawnPacketHandler(p -> this.start());
        LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " tracker created: " + this.name());
        this.animate("idle", AnimationModifier.builder().start(6).type(AnimationIterator.Type.LOOP).build());
    }

    public boolean isScheduled() {
        return this.task != null && !this.task.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (this.isScheduled()) {
            return;
        }
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.isScheduled()) {
                return;
            }
            this.updater.run();
            this.task = EXECUTOR.scheduleAtFixedRate(() -> {
                if (this.playerCount() == 0 && !this.forRemoval.get()) {
                    this.shutdown();
                    return;
                }
                this.updater.run();
                ++this.frame;
            }, 10L, 10L, TimeUnit.MILLISECONDS);
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " scheduler started: " + this.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        if (!this.isScheduled()) {
            return;
        }
        Tracker tracker = this;
        synchronized (tracker) {
            if (!this.isScheduled()) {
                return;
            }
            this.task.cancel(true);
            this.task = null;
            this.frame = 0L;
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " scheduler shutdown: " + this.name());
        }
    }

    @NotNull
    public ModelRotation rotation() {
        return this.rotator.apply(this, this.rotationSupplier.get());
    }

    public final void rotation(@NotNull Supplier<ModelRotation> supplier) {
        this.rotationSupplier = Objects.requireNonNull(supplier);
    }

    public final void rotator(@NotNull ModelRotator rotator) {
        this.rotator = Objects.requireNonNull(rotator);
    }

    @NotNull
    public ModelScaler scaler() {
        return this.scaler;
    }

    public void scaler(@NotNull ModelScaler scaler) {
        this.scaler = Objects.requireNonNull(scaler);
    }

    public void task(@NotNull Runnable runnable) {
        this.queuedTask.add(Objects.requireNonNull(runnable));
    }

    public synchronized void frame(@NotNull ScheduledPacketHandler handler) {
        this.handler = this.handler.then(Objects.requireNonNull(handler));
    }

    public void tick(@NotNull ScheduledPacketHandler handler) {
        this.tick(1L, handler);
    }

    public void tick(long tick, @NotNull ScheduledPacketHandler handler) {
        this.schedule(5L * tick, handler);
    }

    public synchronized void perPlayerTick(@NotNull BiConsumer<Tracker, Player> perPlayerHandler) {
        BiConsumer<Tracker, Player> previous = this.perPlayerHandler;
        this.perPlayerHandler = previous == null ? perPlayerHandler : previous.andThen(perPlayerHandler);
    }

    public void schedule(long period, @NotNull ScheduledPacketHandler handler) {
        Objects.requireNonNull(handler);
        if (period <= 0L) {
            throw new RuntimeException("period cannot be <= 0");
        }
        this.frame((t, s) -> {
            if (this.frame % period == 0L) {
                handler.handle(t, s);
            }
        });
    }

    protected void update() {
        this.updater.run();
    }

    @NotNull
    public String name() {
        return this.pipeline.name();
    }

    public double height() {
        return this.bones().stream().filter(bone -> bone.name().tagged(BoneTags.HEAD, BoneTags.HEAD_WITH_CHILDREN)).mapToDouble(bone -> bone.hitBoxPosition().y).max().orElse(0.0);
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        this.close(CloseReason.REMOVE);
    }

    protected void close(@NotNull CloseReason reason) {
        if (this.isClosed.compareAndSet(false, true)) {
            this.closeEventHandler.accept(this, reason);
            this.shutdown();
            this.pipeline.despawn();
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " closed: " + this.name());
        }
    }

    public void despawn() {
        if (!this.isClosed()) {
            this.pipeline.despawn();
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " despawned: " + this.name());
        }
    }

    @NotNull
    public TrackerModifier modifier() {
        return this.modifier;
    }

    public boolean pause(boolean pause) {
        return this.tickPause.compareAndSet(!pause, pause);
    }

    public boolean forceUpdate(boolean force) {
        return this.readyForForceUpdate.compareAndSet(!force, force);
    }

    protected boolean spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        if (this.isClosed()) {
            return false;
        }
        if (!EventUtil.call(new ModelSpawnAtPlayerEvent(player, this))) {
            return false;
        }
        boolean result = this.pipeline.spawn(player, bundler);
        if (result) {
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " is spawned at player " + player.getName() + ": " + this.name());
        }
        return result;
    }

    public boolean remove(@NotNull Player player) {
        if (this.isClosed()) {
            return false;
        }
        EventUtil.call(new ModelDespawnAtPlayerEvent(player, this));
        boolean result = this.pipeline.remove(player);
        if (result) {
            LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> this.getClass().getSimpleName() + " is despawned at player " + player.getName() + ": " + this.name());
        }
        return result;
    }

    public int playerCount() {
        return this.pipeline.playerCount();
    }

    @NotNull
    public Stream<Player> viewedPlayer() {
        return this.pipeline.viewedPlayer();
    }

    @NotNull
    public abstract Location location();

    public boolean animate(@NotNull String animation) {
        return this.animate(animation, AnimationModifier.DEFAULT);
    }

    public boolean animate(@NotNull String animation, AnimationModifier modifier) {
        return this.animate(animation, modifier, () -> {});
    }

    public boolean animate(@NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.animate((RenderedBone b) -> true, animation, modifier, removeTask);
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        return this.animate(filter, animation, modifier, AnimationEventHandler.start().onAnimationRemove(removeTask));
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, @NotNull AnimationModifier modifier, @NotNull AnimationEventHandler eventHandler) {
        return this.pipeline.animate(filter, animation, modifier, this.injectEvent(eventHandler));
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull BlueprintAnimation animation, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        return this.animate(filter, animation, modifier, AnimationEventHandler.start().onAnimationRemove(removeTask));
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull BlueprintAnimation animation, @NotNull AnimationModifier modifier, @NotNull AnimationEventHandler eventHandler) {
        return this.pipeline.animate(filter, animation, modifier, this.injectEvent(eventHandler));
    }

    public boolean stopAnimation(@NotNull String animation) {
        return this.stopAnimation(e -> true, animation);
    }

    public boolean stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String animation) {
        return this.stopAnimation(filter, animation, null);
    }

    public boolean stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, @Nullable Player player) {
        return this.pipeline.stopAnimation(filter, animation, player);
    }

    public boolean replace(@NotNull String target, @NotNull String animation, @NotNull AnimationModifier modifier) {
        return this.replace((RenderedBone t) -> true, target, animation, modifier);
    }

    public boolean replace(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation, @NotNull AnimationModifier modifier) {
        return this.pipeline.replace(filter, target, animation, modifier);
    }

    public boolean replace(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull BlueprintAnimation animation, @NotNull AnimationModifier modifier) {
        return this.pipeline.replace(filter, target, animation, modifier);
    }

    public void tint(int rgb) {
        if (this.tint(BonePredicate.TRUE, rgb)) {
            this.forceUpdate(true);
        }
    }

    public boolean tint(@NotNull BonePredicate predicate, int rgb) {
        return this.tryUpdate(TrackerUpdateAction.tint(rgb), predicate);
    }

    public boolean createHitBox(@NotNull EntityAdapter entity, @NotNull BonePredicate predicate, @Nullable HitBoxListener listener) {
        return this.tryUpdate((b, p) -> b.createHitBox(entity, (Predicate<RenderedBone>)p, listener), predicate);
    }

    public boolean createNametag(@NotNull BonePredicate predicate, @NotNull BiConsumer<RenderedBone, ModelNametag> consumer) {
        return this.tryUpdate((b, p) -> b.createNametag((Predicate<RenderedBone>)p, (ModelNametag tag) -> {
            consumer.accept((RenderedBone)b, (ModelNametag)tag);
            this.perPlayerTick((tracker, player) -> {
                RenderSource<?> patt1$temp = this.pipeline.getSource();
                if (patt1$temp instanceof RenderSource.BasePlayer) {
                    RenderSource.BasePlayer $b$0 = (RenderSource.BasePlayer)patt1$temp;
                    try {
                        Player patt2$temp;
                        Player entity = patt2$temp = $b$0.entity();
                        if (entity == player) {
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                tag.teleport(tracker.location());
                tag.send((Player)player);
            });
        }), predicate);
    }

    public void updateDisplay(@NotNull Predicate<RenderedBone> predicate) {
        this.updateDisplay(BonePredicate.from(predicate));
    }

    public void updateDisplay(@NotNull BonePredicate predicate) {
        if (this.tryUpdate((b, p) -> b.updateItem((Predicate<RenderedBone>)p, this.pipeline.getSource()), predicate)) {
            this.forceUpdate(true);
        }
    }

    public <T extends TrackerUpdateAction> void update(@NotNull T action) {
        this.update(action, BonePredicate.TRUE);
    }

    public <T extends TrackerUpdateAction> void update(@NotNull T action, @NotNull Predicate<RenderedBone> predicate) {
        this.update(action, BonePredicate.from(predicate));
    }

    public <T extends TrackerUpdateAction> void update(@NotNull T action, @NotNull BonePredicate predicate) {
        if (this.tryUpdate(action, predicate)) {
            this.forceUpdate(true);
        }
    }

    public boolean tryUpdate(@NotNull BiPredicate<RenderedBone, BonePredicate> action, @NotNull BonePredicate predicate) {
        return this.pipeline.matchTree(predicate, action);
    }

    @Nullable
    public RenderedBone bone(@NotNull BoneName name) {
        return this.pipeline.boneOf(name);
    }

    @Nullable
    public RenderedBone bone(@NotNull String name) {
        return this.bone((RenderedBone b) -> b.name().name().equals(name));
    }

    @Nullable
    public RenderedBone bone(@NotNull Predicate<RenderedBone> predicate) {
        return this.pipeline.boneOf(predicate);
    }

    @NotNull
    public @Unmodifiable Collection<RenderedBone> bones() {
        return this.pipeline.bones();
    }

    @NotNull
    public Stream<ModelDisplay> displays() {
        return this.bones().stream().map(RenderedBone::getDisplay).filter(Objects::nonNull);
    }

    public boolean hide(@NotNull Player player) {
        return EventUtil.call(new PlayerHideTrackerEvent(this, player)) && this.pipeline.hide(player);
    }

    public boolean isHide(@NotNull Player player) {
        return this.pipeline.isHide(player);
    }

    public boolean show(@NotNull Player player) {
        return EventUtil.call(new PlayerShowTrackerEvent(this, player)) && this.pipeline.show(player);
    }

    public void handleCloseEvent(@NotNull BiConsumer<Tracker, CloseReason> consumer) {
        this.closeEventHandler = this.closeEventHandler.andThen(Objects.requireNonNull(consumer));
    }

    public boolean isSpawned(@NotNull UUID uuid) {
        return this.pipeline.isSpawned(uuid);
    }

    public boolean isSpawned(@NotNull Player player) {
        return this.isSpawned(player.getUniqueId());
    }

    @NotNull
    public ModelRenderer renderer() {
        return this.pipeline.getParent();
    }

    @ApiStatus.Internal
    public void forRemoval(boolean removal) {
        this.forRemoval.set(removal);
    }

    @ApiStatus.Internal
    public boolean forRemoval() {
        return this.forRemoval.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tracker)) {
            return false;
        }
        Tracker tracker = (Tracker)o;
        return this.name().equals(tracker.name());
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    @NotNull
    private AnimationEventHandler injectEvent(@NotNull AnimationEventHandler eventHandler) {
        return eventHandler.onStateCreated(uuid -> this.bundlerSet.perPlayerViewBundler.computeIfAbsent((UUID)uuid, u -> new PerPlayerCache((UUID)uuid)).add()).onStateRemoved(uuid -> {
            PerPlayerCache get = this.bundlerSet.perPlayerViewBundler.get(uuid);
            if (get != null) {
                get.remove();
            }
        });
    }

    @Generated
    public RenderPipeline getPipeline() {
        return this.pipeline;
    }

    @FunctionalInterface
    public static interface ScheduledPacketHandler {
        public void handle(@NotNull Tracker var1, @NotNull BundlerSet var2);

        @NotNull
        default public ScheduledPacketHandler then(@NotNull ScheduledPacketHandler other) {
            return (t, s) -> {
                this.handle(t, s);
                other.handle(t, s);
            };
        }
    }

    public class BundlerSet {
        private PacketBundler tickBundler;
        private PacketBundler dataBundler;
        private PacketBundler viewBundler;
        private final Map<UUID, PerPlayerCache> perPlayerViewBundler;

        private BundlerSet() {
            this.tickBundler = Tracker.this.pipeline.createBundler();
            this.dataBundler = Tracker.this.pipeline.createLazyBundler();
            this.viewBundler = Tracker.this.pipeline.createParallelBundler();
            this.perPlayerViewBundler = new ConcurrentHashMap<UUID, PerPlayerCache>();
        }

        private void send() {
            this.globalSend();
            this.perPlayerSend();
        }

        private void perPlayerSend() {
            this.perPlayerViewBundler.values().forEach(PerPlayerCache::send);
        }

        private void globalSend() {
            if (this.tickBundler.isNotEmpty()) {
                Tracker.this.pipeline.allPlayer().forEach(this.tickBundler::send);
                this.tickBundler = Tracker.this.pipeline.createBundler();
            }
            if (this.dataBundler.isNotEmpty()) {
                Tracker.this.pipeline.nonHidePlayer().forEach(this.dataBundler::send);
                this.dataBundler = Tracker.this.pipeline.createLazyBundler();
            }
            if (this.viewBundler.isNotEmpty()) {
                Tracker.this.pipeline.viewedPlayer().filter(p -> !this.perPlayerViewBundler.containsKey(p.getUniqueId())).forEach(this.viewBundler::send);
                this.viewBundler = Tracker.this.pipeline.createParallelBundler();
            }
        }

        @Generated
        public PacketBundler getTickBundler() {
            return this.tickBundler;
        }

        @Generated
        public PacketBundler getDataBundler() {
            return this.dataBundler;
        }

        @Generated
        public PacketBundler getViewBundler() {
            return this.viewBundler;
        }
    }

    public static enum CloseReason {
        REMOVE(false),
        DESPAWN(true);

        private final boolean save;

        public boolean shouldBeSave() {
            return this.save;
        }

        @Generated
        private CloseReason(boolean save) {
            this.save = save;
        }
    }

    private class PerPlayerCache {
        private final UUID uuid;
        private final AtomicInteger counter = new AtomicInteger();
        private PacketBundler bundler;

        @NotNull
        private Optional<PlayerChannelHandler> channel() {
            return Optional.ofNullable(Tracker.this.pipeline.channel(this.uuid));
        }

        public void add() {
            if (this.counter.getAndIncrement() == 0) {
                this.channel().ifPresent(handler -> EventUtil.call(new PlayerPerAnimationStartEvent(Tracker.this, handler.player())));
            }
        }

        public void remove() {
            if (this.counter.decrementAndGet() == 0) {
                Tracker.this.bundlerSet.perPlayerViewBundler.remove(this.uuid);
                this.channel().ifPresent(handler -> {
                    PacketBundler bundler = Tracker.this.pipeline.createBundler();
                    Tracker.this.pipeline.iterateTree(bone -> bone.forceTransformation(bundler));
                    bundler.send(handler.player());
                    EventUtil.call(new PlayerPerAnimationEndEvent(Tracker.this, handler.player()));
                });
            }
        }

        private void send() {
            if (Tracker.this.pipeline.tick(this.uuid, this.bundler) && this.bundler.isNotEmpty()) {
                this.channel().ifPresent(handler -> this.bundler.send(handler.player()));
                this.bundler = Tracker.this.pipeline.createParallelBundler();
            }
        }

        @Generated
        public PerPlayerCache(UUID uuid) {
            this.bundler = Tracker.this.pipeline.createParallelBundler();
            this.uuid = uuid;
        }
    }
}

