/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.manager.PlayerManager;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.manager.GlobalManager;
import kr.toxicity.model.manager.PlayerManagerImpl;
import kr.toxicity.model.manager.ReloadPipeline;
import kr.toxicity.model.manager.SkinManagerImpl;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Pair;
import kr.toxicity.model.shaded.kotlin.Result;
import kr.toxicity.model.shaded.kotlin.ResultKt;
import kr.toxicity.model.shaded.kotlin.TuplesKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.collections.MapsKt;
import kr.toxicity.model.shaded.kotlin.io.path.PathsKt;
import kr.toxicity.model.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.FilesKt;
import kr.toxicity.model.util.GsonsKt;
import kr.toxicity.model.util.PluginsKt;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\b*\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0016J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0016J\f\u0010&\u001a\u00020\f*\u00020'H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0013H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lkr/toxicity/model/manager/PlayerManagerImpl;", "Lkr/toxicity/model/api/manager/PlayerManager;", "Lkr/toxicity/model/manager/GlobalManager;", "<init>", "()V", "playerMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lkr/toxicity/model/api/nms/PlayerChannelHandler;", "renderMap", "Ljava/util/HashMap;", "", "Lkr/toxicity/model/api/data/renderer/ModelRenderer;", "Lkr/toxicity/model/shaded/kotlin/collections/HashMap;", "rendererView", "", "start", "", "register", "Lorg/bukkit/entity/Player;", "reload", "pipeline", "Lkr/toxicity/model/manager/ReloadPipeline;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "limbs", "", "limb", "name", "keys", "", "animate", "", "player", "model", "animation", "modifier", "Lkr/toxicity/model/api/animation/AnimationModifier;", "toRenderer", "Lkr/toxicity/model/api/data/blueprint/ModelBlueprint;", "uuid", "core"})
@SourceDebugExtension(value={"SMAP\nPlayerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerManagerImpl.kt\nkr/toxicity/model/manager/PlayerManagerImpl\n+ 2 Files.kt\nkr/toxicity/model/util/FilesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n9#2,6:111\n808#3,11:117\n1193#3,2:128\n1267#3,4:130\n808#3,11:134\n1193#3,2:145\n1267#3,4:147\n*S KotlinDebug\n*F\n+ 1 PlayerManagerImpl.kt\nkr/toxicity/model/manager/PlayerManagerImpl\n*L\n59#1:111,6\n102#1:117,11\n103#1:128,2\n103#1:130,4\n95#1:134,11\n96#1:145,2\n96#1:147,4\n*E\n"})
public final class PlayerManagerImpl
implements PlayerManager,
GlobalManager {
    @NotNull
    public static final PlayerManagerImpl INSTANCE = new PlayerManagerImpl();
    @NotNull
    private static final ConcurrentHashMap<UUID, PlayerChannelHandler> playerMap = new ConcurrentHashMap();
    @NotNull
    private static final HashMap<String, ModelRenderer> renderMap = new HashMap();
    @NotNull
    private static final Map<String, ModelRenderer> rendererView = kr.toxicity.model.util.CollectionsKt.toImmutableView(renderMap);

    private PlayerManagerImpl() {
    }

    @Override
    public void start() {
        EventsKt.registerListener(new Listener(){

            @EventHandler
            public final void join(PlayerJoinEvent $this$join) {
                block3: {
                    Object $this$join_u24lambda_u240;
                    Intrinsics.checkNotNullParameter($this$join, "<this>");
                    if (!$this$join.getPlayer().isOnline()) break block3;
                    PlayerJoinEvent playerJoinEvent = $this$join;
                    try {
                        $this$join_u24lambda_u240 = playerJoinEvent;
                        boolean bl = false;
                        Player player = $this$join_u24lambda_u240.getPlayer();
                        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                        $this$join_u24lambda_u240 = Result.constructor-impl(PlayerManagerImpl.access$register(PlayerManagerImpl.INSTANCE, player));
                    }
                    catch (Throwable throwable) {
                        $this$join_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(throwable));
                    }
                    Object $this$handleFailure$iv = $this$join_u24lambda_u240;
                    boolean $i$f$handleFailure = false;
                    Object object = $this$handleFailure$iv;
                    Throwable throwable = Result.exceptionOrNull-impl(object);
                    if (throwable != null) {
                        Throwable throwable2;
                        Throwable it$iv = throwable2 = throwable;
                        boolean bl = false;
                        Throwable throwable3 = it$iv;
                        boolean bl2 = false;
                        PluginsKt.handleException(throwable3, "Unable to load " + $this$join.getPlayer().getName() + "'s data.");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @EventHandler
            public final void quit(PlayerQuitEvent $this$quit) {
                Intrinsics.checkNotNullParameter($this$quit, "<this>");
                PlayerChannelHandler playerChannelHandler = (PlayerChannelHandler)PlayerManagerImpl.access$getPlayerMap$p().remove($this$quit.getPlayer().getUniqueId());
                if (playerChannelHandler != null) {
                    AutoCloseable autoCloseable = playerChannelHandler;
                    Throwable throwable = null;
                    try {
                        PlayerChannelHandler it = (PlayerChannelHandler)autoCloseable;
                        boolean bl = false;
                        GameProfile gameProfile = it.profile();
                        Intrinsics.checkNotNullExpressionValue(gameProfile, "profile(...)");
                        Boolean bl2 = SkinManagerImpl.INSTANCE.removeCache(gameProfile);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
            }
        });
    }

    private final PlayerChannelHandler register(Player $this$register) {
        PlayerChannelHandler playerChannelHandler;
        PlayerChannelHandler $this$register_u24lambda_u242 = playerChannelHandler = playerMap.computeIfAbsent($this$register.getUniqueId(), arg_0 -> PlayerManagerImpl.register$lambda$1(arg_0 -> PlayerManagerImpl.register$lambda$0($this$register, arg_0), arg_0));
        boolean bl = false;
        if (SkinManagerImpl.INSTANCE.supported()) {
            GameProfile gameProfile = $this$register_u24lambda_u242.profile();
            Intrinsics.checkNotNullExpressionValue(gameProfile, "profile(...)");
            SkinManagerImpl.INSTANCE.getOrRequest(gameProfile);
        }
        PlayerChannelHandler playerChannelHandler2 = playerChannelHandler;
        Intrinsics.checkNotNullExpressionValue(playerChannelHandler2, "apply(...)");
        return playerChannelHandler2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void reload(@NotNull ReloadPipeline pipeline, @NotNull PackZipper zipper) {
        Intrinsics.checkNotNullParameter(pipeline, "pipeline");
        Intrinsics.checkNotNullParameter(zipper, "zipper");
        renderMap.clear();
        if (PluginsKt.getCONFIG().module().playerAnimation()) {
            List<Object> list;
            void $this$getOrCreateDirectory$iv;
            File file;
            Object object = PluginsKt.getDATA_FOLDER();
            String name$iv = "players";
            boolean $i$f$getOrCreateDirectory = false;
            File target$iv = file = new File((File)$this$getOrCreateDirectory$iv, name$iv);
            boolean bl = false;
            if (!target$iv.exists()) {
                target$iv.mkdirs();
                File folder = target$iv;
                boolean bl2 = false;
                FilesKt.addResource(folder, "steve.bbmodel");
            }
            object = FilesKt.fileTreeList(file);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)object;
                boolean bl3 = false;
                list = stream.filter(arg_0 -> PlayerManagerImpl.reload$lambda$6$lambda$5(PlayerManagerImpl::reload$lambda$6$lambda$4, arg_0)).toList();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
            }
            List<Object> target = list;
            pipeline.setStatus("Importing player model...");
            pipeline.goal(target.size());
            Intrinsics.checkNotNull(target);
            pipeline.forEachParallel(target, reload.1.INSTANCE, PlayerManagerImpl::reload$lambda$7);
        }
    }

    @Override
    @NotNull
    public Collection<ModelRenderer> limbs() {
        return rendererView.values();
    }

    @Override
    @Nullable
    public ModelRenderer limb(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return rendererView.get(name);
    }

    @Override
    @NotNull
    public Set<String> keys() {
        return rendererView.keySet();
    }

    @Override
    public boolean animate(@NotNull Player player, @NotNull String model, @NotNull String animation, @NotNull AnimationModifier modifier) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(model, "model");
        Intrinsics.checkNotNullParameter(animation, "animation");
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        ModelRenderer modelRenderer = renderMap.get(model);
        if (modelRenderer != null) {
            ModelRenderer it = modelRenderer;
            boolean bl2 = false;
            EntityTracker entityTracker = it.getOrCreate((Entity)player);
            Intrinsics.checkNotNullExpressionValue(entityTracker, "getOrCreate(...)");
            EntityTracker create2 = entityTracker;
            boolean success = create2.animate(animation, modifier, () -> PlayerManagerImpl.animate$lambda$9$lambda$8(create2));
            if (!success) {
                create2.close();
            }
            bl = success;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final ModelRenderer toRenderer(ModelBlueprint $this$toRenderer) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        List<BlueprintChildren> list = $this$toRenderer.group();
        Intrinsics.checkNotNullExpressionValue(list, "group(...)");
        Iterable iterable = list;
        ModelBlueprint modelBlueprint = $this$toRenderer;
        boolean $i$f$filterIsInstance = false;
        void var4_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BlueprintChildren.BlueprintGroup)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            BlueprintChildren.BlueprintGroup it = (BlueprintChildren.BlueprintGroup)element$iv$iv;
            boolean bl = false;
            Pair<BoneName, RendererGroup> pair = TuplesKt.to(it.name(), PlayerManagerImpl.toRenderer$parse(it, $this$toRenderer));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map<String, BlueprintAnimation> map = $this$toRenderer.animations();
        Map map2 = destination$iv$iv2;
        ModelBlueprint modelBlueprint2 = modelBlueprint;
        return new ModelRenderer(modelBlueprint2, map2, map);
    }

    @Override
    @Nullable
    public PlayerChannelHandler player(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return playerMap.get(uuid);
    }

    @Override
    @NotNull
    public PlayerChannelHandler player(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.register(player);
    }

    @Override
    public void end() {
        GlobalManager.super.end();
    }

    private static final PlayerChannelHandler register$lambda$0(Player $this_register, UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return PluginsKt.getPLUGIN().nms().inject($this_register);
    }

    private static final PlayerChannelHandler register$lambda$1(Function1 $tmp0, Object p0) {
        return (PlayerChannelHandler)$tmp0.invoke(p0);
    }

    private static final boolean reload$lambda$6$lambda$4(Path it) {
        Intrinsics.checkNotNull(it);
        return Intrinsics.areEqual(PathsKt.getExtension(it), "bbmodel");
    }

    private static final boolean reload$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit reload$lambda$7(Path it) {
        File file = it.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        ModelBlueprint load = GsonsKt.toModel(file);
        ((Map)renderMap).put(load.name(), INSTANCE.toRenderer(load));
        return Unit.INSTANCE;
    }

    private static final void animate$lambda$9$lambda$8(EntityTracker $create) {
        $create.close();
    }

    /*
     * WARNING - void declaration
     */
    private static final RendererGroup toRenderer$parse(BlueprintChildren.BlueprintGroup $this$toRenderer_u24parse, ModelBlueprint $this_toRenderer) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        BoneName boneName = $this$toRenderer_u24parse.name();
        float f = $this_toRenderer.scale();
        ItemStack itemStack = new ItemStack(Material.AIR);
        List<BlueprintChildren> list = $this$toRenderer_u24parse.children();
        Intrinsics.checkNotNullExpressionValue(list, "children(...)");
        Iterable iterable = list;
        BlueprintChildren.BlueprintGroup blueprintGroup = $this$toRenderer_u24parse;
        ItemStack itemStack2 = itemStack;
        float f2 = f;
        BoneName boneName2 = boneName;
        boolean $i$f$filterIsInstance = false;
        void var4_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BlueprintChildren.BlueprintGroup)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        $this$filterIsInstance$iv = (Iterable)object;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            BlueprintChildren.BlueprintGroup it = (BlueprintChildren.BlueprintGroup)element$iv$iv;
            boolean bl = false;
            Pair<BoneName, RendererGroup> pair = TuplesKt.to(it.name(), PlayerManagerImpl.toRenderer$parse(it, $this_toRenderer));
            map.put(pair.getFirst(), pair.getSecond());
        }
        object = destination$iv$iv2;
        NamedBoundingBox namedBoundingBox = $this$toRenderer_u24parse.hitBox();
        Object object2 = object;
        BlueprintChildren.BlueprintGroup blueprintGroup2 = blueprintGroup;
        ItemStack itemStack3 = itemStack2;
        float f3 = f2;
        BoneName boneName3 = boneName2;
        return new RendererGroup(boneName3, f3, itemStack3, blueprintGroup2, (Map<BoneName, RendererGroup>)object2, namedBoundingBox);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPlayerMap$p() {
        return playerMap;
    }

    public static final /* synthetic */ PlayerChannelHandler access$register(PlayerManagerImpl $this, Player $receiver) {
        return $this.register($receiver);
    }
}

