/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVNamespace;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVUtil;
import org.jetbrains.annotations.NotNull;

public interface UVByteBuilder {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    @NotNull
    public String path();

    public byte[] build();

    public long estimatedSize();

    @NotNull
    public static UVByteBuilder emptyImage(@NotNull UVNamespace namespace, @NotNull String textureName) {
        return UVByteBuilder.of(namespace.texture(textureName), UVUtil.EMPTY_IMAGE);
    }

    @NotNull
    public static UVByteBuilder of(@NotNull String path, @NotNull JsonElement element) {
        return UVByteBuilder.of(path, UVUtil.estimateSize(element), () -> GSON.toJson(element).getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static UVByteBuilder of(@NotNull String path, @NotNull BufferedImage image) {
        return UVByteBuilder.of(path, 4L * (long)image.getHeight() * (long)image.getWidth(), () -> {
            byte[] byArray;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "png", bytes);
                byArray = bytes.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bytes.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            bytes.close();
            return byArray;
        });
    }

    @NotNull
    public static UVByteBuilder of(final @NotNull String path, final long estimatedSize, final @NotNull Supplier<byte[]> supplier) {
        return new UVByteBuilder(){

            @Override
            @NotNull
            public String path() {
                return path;
            }

            @Override
            public byte[] build() {
                return (byte[])supplier.get();
            }

            @Override
            public long estimatedSize() {
                return estimatedSize;
            }
        };
    }
}

