/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.api.data.blueprint.BlueprintElement;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.data.raw.ModelGroup;
import kr.toxicity.model.api.data.raw.ModelLoadContext;
import kr.toxicity.model.api.util.CollectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public sealed interface ModelChildren {
    public static final JsonDeserializer<ModelChildren> PARSER = (json, typeOfT, context) -> {
        if (json.isJsonPrimitive()) {
            return new ModelUUID(json.getAsString());
        }
        if (json.isJsonObject()) {
            JsonArray children = json.getAsJsonObject().getAsJsonArray("children");
            return new ModelOutliner((ModelGroup)context.deserialize(json, ModelGroup.class), children.asList().stream().map(child -> (ModelChildren)context.deserialize(child, ModelChildren.class)).toList());
        }
        throw new RuntimeException();
    };

    @NotNull
    public BlueprintElement toBlueprint(@NotNull ModelLoadContext var1);

    @NotNull
    public Stream<ModelChildren> flatten();

    @NotNull
    public String uuid();

    public record ModelUUID(@NotNull String uuid) implements ModelChildren
    {
        @Override
        @NotNull
        public BlueprintElement toBlueprint(@NotNull ModelLoadContext context) {
            ModelElement get = Objects.requireNonNull(context.elements.get(this.uuid()));
            UUID uid = UUID.fromString(this.uuid);
            ModelElement modelElement = get;
            Objects.requireNonNull(modelElement);
            ModelElement modelElement2 = modelElement;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModelElement.Cube.class, ModelElement.Locator.class, ModelElement.NullObject.class, ModelElement.Unsupported.class}, (Object)modelElement2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ModelElement.Cube cube = (ModelElement.Cube)modelElement2;
                    yield new BlueprintElement.BlueprintCube(cube.name(), cube.from(), cube.to(), cube.inflate(), cube.rotation(), cube.origin(), cube.faces(), cube.visibility());
                }
                case 1 -> {
                    ModelElement.Locator locator = (ModelElement.Locator)modelElement2;
                    yield new BlueprintElement.BlueprintLocator(uid, BoneTagRegistry.parse(locator.name()), locator.position());
                }
                case 2 -> {
                    ModelElement.NullObject nullObject = (ModelElement.NullObject)modelElement2;
                    yield new BlueprintElement.BlueprintNullObject(uid, BoneTagRegistry.parse(nullObject.name()), Optional.ofNullable(nullObject.ikTarget()).filter(str -> !str.isEmpty()).map(UUID::fromString).orElse(null), Optional.ofNullable(nullObject.ikSource()).filter(str -> !str.isEmpty()).map(UUID::fromString).orElse(null), nullObject.position());
                }
                case 3 -> {
                    ModelElement.Unsupported ignored = (ModelElement.Unsupported)modelElement2;
                    throw new UnsupportedOperationException(ignored.type());
                }
            };
        }

        @Override
        @NotNull
        public Stream<ModelChildren> flatten() {
            return Stream.of(this);
        }
    }

    public record ModelOutliner(@NotNull ModelGroup group, @NotNull @Unmodifiable List<ModelChildren> children) implements ModelChildren
    {
        @Override
        @NotNull
        public BlueprintElement toBlueprint(@NotNull ModelLoadContext context) {
            List<BlueprintElement> child = CollectionUtil.mapToList(this.children, c -> c.toBlueprint(context));
            List<BlueprintElement.BlueprintCube> filtered = CollectionUtil.filterIsInstance(child, BlueprintElement.BlueprintCube.class).toList();
            ModelGroup selectedGroup = context.groups.getOrDefault(this.uuid(), this.group);
            return new BlueprintElement.BlueprintGroup(UUID.fromString(selectedGroup.uuid()), BoneTagRegistry.parse(selectedGroup.name()), selectedGroup.origin(), selectedGroup.rotation().invertXZ(), child, filtered.isEmpty() ? selectedGroup.visibility() : filtered.stream().anyMatch(BlueprintElement.BlueprintCube::visibility));
        }

        @Override
        @NotNull
        public Stream<ModelChildren> flatten() {
            return Stream.concat(Stream.of(this), this.children.stream().flatMap(ModelChildren::flatten));
        }

        @Override
        @NotNull
        public String uuid() {
            return this.group.uuid();
        }
    }
}

