/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.Tracker;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ModelScaler
permits Composite, Deserializer.Pack {
    public static final Deserializer DESERIALIZER = new Deserializer();

    @NotNull
    public String name();

    public float scale(@NotNull Tracker var1);

    @Nullable
    public JsonElement data();

    @NotNull
    public static ModelScaler deserialize(@NotNull JsonObject element) {
        ModelScaler scaler = DESERIALIZER.buildScaler(element);
        return scaler != null ? scaler : ModelScaler.defaultScaler();
    }

    @NotNull
    public static ModelScaler defaultScaler() {
        return DESERIALIZER.defaultScaler();
    }

    @NotNull
    public static ModelScaler entity() {
        return ModelScaler.DESERIALIZER.entity.deserialize();
    }

    @NotNull
    public static ModelScaler value(float value) {
        return ModelScaler.DESERIALIZER.value.deserialize(value);
    }

    @NotNull
    public static ModelScaler composite(ModelScaler ... scalers) {
        return new Composite(new Composite.CompositeGetter(Arrays.asList(scalers)));
    }

    @NotNull
    default public ModelScaler multiply(float value) {
        return this.composite(ModelScaler.value(value));
    }

    @NotNull
    default public ModelScaler composite(@NotNull ModelScaler scaler) {
        Composite composite;
        ArrayList<ModelScaler> list = new ArrayList<ModelScaler>();
        ModelScaler modelScaler = this;
        if (modelScaler instanceof Composite) {
            composite = (Composite)modelScaler;
            list.addAll(composite.getter.list);
        } else {
            list.add(this);
        }
        if (scaler instanceof Composite) {
            composite = (Composite)scaler;
            list.addAll(composite.getter.list);
        } else {
            list.add(scaler);
        }
        return new Composite(new Composite.CompositeGetter(list));
    }

    @NotNull
    default public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name());
        JsonElement d = this.data();
        if (d != null) {
            json.add("data", d);
        }
        return json;
    }

    public static final class Deserializer {
        private final Map<String, Builder> getterMap = new HashMap<String, Builder>();
        private final BuiltInDeserializer def = this.addScaler("default", d -> Getter.DEFAULT);
        private final BuiltInDeserializer entity = this.addScaler("entity", d -> Getter.ENTITY);
        private final BuiltInDeserializer value = this.addScaler("value", d -> d.isJsonPrimitive() ? Getter.value(d.getAsFloat()) : Getter.DEFAULT);

        private Deserializer() {
            this.getterMap.put("composite", d -> {
                if (d.isJsonArray()) {
                    return new Composite.CompositeGetter(d.getAsJsonArray().asList().stream().filter(JsonElement::isJsonObject).map(element -> this.buildScaler(element.getAsJsonObject())).filter(Objects::nonNull).toList());
                }
                return Getter.DEFAULT;
            });
        }

        @NotNull
        private ModelScaler defaultScaler() {
            return this.def.deserialize();
        }

        @NotNull
        public BuiltInDeserializer addScaler(@NotNull String name, @NotNull Builder builder) {
            Builder put = this.getterMap.putIfAbsent(name, builder);
            Builder target = put != null ? put : builder;
            return element -> this.pack(name, target, (JsonElement)element);
        }

        @Nullable
        public ModelScaler buildScaler(@NotNull JsonObject rawData) {
            JsonPrimitive n = rawData.getAsJsonPrimitive("name");
            if (n == null) {
                return null;
            }
            String name = n.getAsString();
            Builder get = this.getterMap.get(name);
            if (get == null) {
                return null;
            }
            JsonElement d = rawData.get("data");
            return this.pack(name, get, d);
        }

        @NotNull
        private ModelScaler pack(@NotNull String name, @NotNull Builder builder, @Nullable JsonElement data) {
            ModelScaler modelScaler;
            Getter build = Optional.ofNullable(builder.build((JsonElement)(data != null ? data : JsonNull.INSTANCE))).orElse(Getter.DEFAULT);
            if (build instanceof Composite.CompositeGetter) {
                Composite.CompositeGetter compositeGetter = (Composite.CompositeGetter)build;
                modelScaler = new Composite(compositeGetter);
            } else {
                modelScaler = new Pack(name, build, data);
            }
            return modelScaler;
        }

        private record Pack(@NotNull String name, @NotNull Getter getter, @Nullable JsonElement data) implements ModelScaler
        {
            @Override
            public float scale(@NotNull Tracker tracker) {
                return this.getter.get(tracker);
            }
        }
    }

    public static interface BuiltInDeserializer
    extends Function<JsonElement, ModelScaler> {
        @NotNull
        default public ModelScaler deserialize(float value) {
            return (ModelScaler)this.apply(new JsonPrimitive((Number)Float.valueOf(value)));
        }

        @NotNull
        default public ModelScaler deserialize() {
            return (ModelScaler)this.apply(JsonNull.INSTANCE);
        }
    }

    public static final class Composite
    implements ModelScaler {
        private final CompositeGetter getter;

        @Override
        @NotNull
        public String name() {
            return "composite";
        }

        @Override
        public float scale(@NotNull Tracker tracker) {
            return this.getter.get(tracker);
        }

        private void add(@NotNull JsonArray array, @NotNull ModelScaler scaler) {
            if (scaler instanceof Composite) {
                Composite composite = (Composite)scaler;
                for (ModelScaler childScaler : composite.getter.list) {
                    this.add(array, childScaler);
                }
            } else {
                array.add((JsonElement)scaler.serialize());
            }
        }

        @Override
        public JsonElement data() {
            JsonArray arr = new JsonArray();
            for (ModelScaler modelScaler : this.getter.list) {
                this.add(arr, modelScaler);
            }
            return arr.isEmpty() ? null : arr;
        }

        @Generated
        private Composite(CompositeGetter getter) {
            this.getter = getter;
        }

        private record CompositeGetter(@NotNull List<ModelScaler> list) implements Getter
        {
            @Override
            public float get(@NotNull Tracker tracker) {
                float f = 1.0f;
                for (ModelScaler modelScaler : this.list) {
                    f *= modelScaler.scale(tracker);
                }
                return f;
            }
        }
    }

    public static interface Builder {
        @Nullable
        public Getter build(@NotNull JsonElement var1);
    }

    public static interface Getter {
        public static final Getter DEFAULT = t -> 1.0f;
        public static final Getter ENTITY = t -> {
            float f;
            if (t instanceof EntityTracker) {
                EntityTracker entityTracker = (EntityTracker)t;
                f = (float)entityTracker.registry().entity().scale();
            } else {
                f = 1.0f;
            }
            return f;
        };

        public float get(@NotNull Tracker var1);

        @NotNull
        public static Getter value(float value) {
            return t -> value;
        }
    }
}

