/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.MathUtil;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class BoneIKSolver {
    private static final int MAX_IK_ITERATION = 20;
    private final Map<UUID, RenderedBone> boneMap;
    private final Map<RenderedBone, List<RenderedBone>> locators = new LinkedHashMap<RenderedBone, List<RenderedBone>>();

    public void addLocator(@Nullable UUID ikSource, @NotNull UUID ikTarget, @NotNull RenderedBone locator) {
        RenderedBone target = this.boneMap.get(ikTarget);
        if (target == null) {
            return;
        }
        List<RenderedBone> list = (ikSource == null ? target.root : this.boneMap.getOrDefault(ikSource, target.root)).flatten().filter(bone -> bone.flattenBones().contains(target)).toList();
        if (list.size() < 2) {
            return;
        }
        this.locators.put(locator, list);
    }

    public void solve() {
        this.solve(null);
    }

    public void solve(@Nullable UUID uuid) {
        for (Map.Entry<RenderedBone, List<RenderedBone>> entry : this.locators.entrySet()) {
            RenderedBone locator = entry.getKey();
            RenderedBone root = entry.getValue().getFirst().root;
            BoneIKSolver.fabrik(entry.getValue().stream().map(bone -> bone.state(uuid)).toList(), locator.root.group.getPosition().add((Vector3fc)locator.state(uuid).after().position(), new Vector3f()).sub((Vector3fc)root.group.getPosition()));
        }
    }

    private static void fabrik(@NotNull List<RenderedBone.BoneStateHandler> bones, @NotNull Vector3f target) {
        int i;
        Vector3f first = bones.getFirst().after().position();
        Vector3f last = bones.getLast().after().position();
        Vector3f rootPos = new Vector3f((Vector3fc)first);
        float[] lengths = new float[bones.size() - 1];
        for (i = 0; i < bones.size() - 1; ++i) {
            lengths[i] = bones.get(i).after().position().distance((Vector3fc)bones.get(i + 1).after().position());
        }
        for (int iter = 0; iter < 20; ++iter) {
            float dist;
            Vector3f next;
            Vector3f current;
            int i2;
            last.set((Vector3fc)target);
            for (i2 = bones.size() - 2; i2 >= 0; --i2) {
                current = bones.get(i2).after().position();
                dist = current.distance((Vector3fc)(next = bones.get(i2 + 1).after().position()));
                if (dist < 1.0E-5f) continue;
                current.set((Vector3fc)InterpolationUtil.lerp(next, current, lengths[i2] / dist));
            }
            first.set((Vector3fc)rootPos);
            for (i2 = 0; i2 < bones.size() - 1; ++i2) {
                current = bones.get(i2).after().position();
                dist = current.distance((Vector3fc)(next = bones.get(i2 + 1).after().position()));
                if (dist < 1.0E-5f) continue;
                next.set((Vector3fc)InterpolationUtil.lerp(current, next, lengths[i2] / dist));
            }
            if (last.distance((Vector3fc)target) < 0.001f) break;
        }
        for (i = 0; i < bones.size() - 1; ++i) {
            BoneMovement current = bones.get(i).after();
            BoneMovement next = bones.get(i + 1).after();
            Vector3f dir = next.position().sub((Vector3fc)current.position(), new Vector3f());
            current.rotation().set((Quaternionfc)MathUtil.fromToRotation(dir).mul((Quaternionfc)current.rotation()));
        }
    }

    @Generated
    public BoneIKSolver(Map<UUID, RenderedBone> boneMap) {
        this.boneMap = boneMap;
    }
}

