/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationEventHandler;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.AnimationPredicate;
import kr.toxicity.model.api.animation.AnimationStateHandler;
import kr.toxicity.model.api.animation.RunningAnimation;
import kr.toxicity.model.api.bone.BoneEventDispatcher;
import kr.toxicity.model.api.bone.BoneEventHandler;
import kr.toxicity.model.api.bone.BoneIKSolver;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.BlueprintElement;
import kr.toxicity.model.api.data.blueprint.ModelBoundingBox;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.entity.BaseEntity;
import kr.toxicity.model.api.nms.DisplayTransformer;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.ModelNametag;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.function.BonePredicate;
import kr.toxicity.model.api.util.function.FloatConstantSupplier;
import kr.toxicity.model.api.util.function.FloatSupplier;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RenderedBone
implements BoneEventHandler {
    private static final int INITIAL_TINT_VALUE = 0xFFFFFF;
    private static final Vector3f EMPTY_VECTOR = new Vector3f();
    @NotNull
    final RendererGroup group;
    private final BoneMovement defaultFrame;
    private final RenderSource<?> renderSource;
    private final BoneEventDispatcher eventDispatcher = new BoneEventDispatcher();
    @NotNull
    final RenderedBone root;
    @Nullable
    final RenderedBone parent;
    private Set<RenderedBone> flattenBones;
    @NotNull
    final Map<BoneName, RenderedBone> children;
    private final Int2ObjectMap<ItemStack> tintCacheMap = new Int2ObjectOpenHashMap();
    private final boolean dummyBone;
    private final Object itemLock = new Object();
    @Nullable
    private final ModelDisplay display;
    @Nullable
    private HitBox hitBox;
    @Nullable
    private ModelNametag nametag;
    private BoneItemMapper itemMapper;
    private volatile int previousTint = 0xFFFFFF;
    private volatile int tint = 0xFFFFFF;
    private volatile TransformedItemStack itemStack;
    private final BoneStateHandler globalState;
    private final Map<UUID, BoneStateHandler> perPlayerState = new ConcurrentHashMap<UUID, BoneStateHandler>();
    private volatile ModelRotation rotation = ModelRotation.EMPTY;
    private Supplier<Vector3f> defaultPosition = FunctionUtil.asSupplier(EMPTY_VECTOR);
    private FloatSupplier scale = FloatConstantSupplier.ONE;
    private Function<Vector3f, Vector3f> positionModifier = p -> p;
    private Vector3f lastModifiedPosition = new Vector3f();
    private Function<Quaternionf, Quaternionf> rotationModifier = r -> r;
    private Quaternionf lastModifiedRotation = new Quaternionf();

    @ApiStatus.Internal
    public RenderedBone(@NotNull RendererGroup group, @Nullable RenderedBone parent, @NotNull RenderSource<?> renderSource, @NotNull BoneMovement movement, @NotNull Function<RenderedBone, Map<BoneName, RenderedBone>> childrenMapper) {
        this.group = group;
        this.parent = parent;
        this.renderSource = renderSource;
        this.itemMapper = group.getItemMapper();
        this.root = parent != null ? parent.root : this;
        this.itemStack = this.itemMapper.apply(renderSource, group.getItemStack());
        this.dummyBone = group.getItemStack().isAir() && this.itemMapper == BoneItemMapper.EMPTY;
        this.defaultFrame = movement;
        this.children = childrenMapper.apply(this);
        this.display = !this.dummyBone ? BetterModel.nms().create(renderSource.location(), renderSource instanceof RenderSource.Entity ? -4096.0 : 0.0, d -> {
            d.display(this.itemMapper.transform());
            d.invisible(!group.getParent().visibility());
            d.viewRange(EntityUtil.ENTITY_MODEL_VIEW_RADIUS);
            this.applyItem((ModelDisplay)d);
        }) : null;
        this.globalState = new BoneStateHandler(null, uuid -> {});
    }

    public void locator(@NotNull BoneIKSolver solver) {
        BlueprintElement.Bone bone = this.getGroup().getParent();
        if (bone instanceof BlueprintElement.BlueprintNullObject) {
            BlueprintElement.BlueprintNullObject nullObject = (BlueprintElement.BlueprintNullObject)bone;
            UUID ikTarget = nullObject.ikTarget();
            if (ikTarget == null) {
                return;
            }
            solver.addLocator(nullObject.ikSource(), ikTarget, this);
        }
    }

    @NotNull
    private BoneStateHandler state(@Nullable Player player) {
        return this.state(player != null ? player.getUniqueId() : null);
    }

    @NotNull
    BoneStateHandler state(@Nullable UUID uuid) {
        return uuid == null ? this.globalState : this.perPlayerState.getOrDefault(uuid, this.globalState);
    }

    @NotNull
    private BoneStateHandler getOrCreateState(@Nullable Player player) {
        return this.getOrCreateState(player != null ? player.getUniqueId() : null);
    }

    @NotNull
    private BoneStateHandler getOrCreateState(@Nullable UUID uuid) {
        return uuid == null ? this.globalState : this.perPlayerState.computeIfAbsent(uuid, u -> {
            this.eventDispatcher.onStateCreated(this, (UUID)u);
            return new BoneStateHandler((UUID)u, targetUUID -> this.eventDispatcher.onStateRemoved(this, (UUID)targetUUID));
        });
    }

    @Nullable
    public RunningAnimation runningAnimation() {
        return this.globalState.state.runningAnimation();
    }

    @Override
    @NotNull
    public BoneEventDispatcher eventDispatcher() {
        return this.eventDispatcher;
    }

    public boolean updateItem(@NotNull Predicate<RenderedBone> predicate) {
        return this.itemStack(predicate, this.itemMapper.apply(this.renderSource, this.itemStack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createHitBox(@NotNull BaseEntity entity, @NotNull Predicate<RenderedBone> predicate, @Nullable HitBoxListener listener) {
        if (predicate.test(this)) {
            HitBox previous = this.hitBox;
            RenderedBone renderedBone = this;
            synchronized (renderedBone) {
                if (previous != this.hitBox) {
                    return false;
                }
                NamedBoundingBox h = this.group.getHitBox();
                if (h == null) {
                    h = ModelBoundingBox.MIN.named(this.name());
                }
                HitBoxListener l = this.eventDispatcher.onCreateHitBox(this, (listener != null ? listener : HitBoxListener.EMPTY).toBuilder()).build();
                if (this.hitBox != null) {
                    this.hitBox.removeHitBox();
                }
                this.hitBox = BetterModel.nms().createHitBox(entity, this, h, this.group.getMountController(), l);
                return this.hitBox != null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNametag(@NotNull Predicate<RenderedBone> predicate, @NotNull Consumer<ModelNametag> consumer) {
        if (this.nametag == null && predicate.test(this)) {
            RenderedBone renderedBone = this;
            synchronized (renderedBone) {
                if (this.nametag != null) {
                    return false;
                }
                this.nametag = BetterModel.nms().createNametag(this, consumer);
            }
            return true;
        }
        return false;
    }

    public boolean enchant(@NotNull Predicate<RenderedBone> predicate, boolean enchant) {
        return this.itemStack(predicate, this.itemStack.modify(i -> {
            ItemMeta meta = i.getItemMeta();
            if (meta == null) {
                return i;
            }
            meta.setEnchantmentGlintOverride(Boolean.valueOf(enchant));
            i.setItemMeta(meta);
            return i;
        }));
    }

    public void scale(@NotNull FloatSupplier scale2) {
        this.scale = scale2;
    }

    public boolean applyAtDisplay(@NotNull Predicate<RenderedBone> predicate, @NotNull Consumer<ModelDisplay> consumer) {
        if (this.display != null && predicate.test(this)) {
            consumer.accept(this.display);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean itemStack(@NotNull Predicate<RenderedBone> predicate, @NotNull TransformedItemStack itemStack) {
        if (this.itemStack != itemStack && predicate.test(this)) {
            Object object = this.itemLock;
            synchronized (object) {
                if (this.itemStack == itemStack) {
                    return false;
                }
                this.itemStack = itemStack;
                if (this.display != null) {
                    this.display.invisible(itemStack.isAir());
                }
                this.tintCacheMap.clear();
                return this.applyItem();
            }
        }
        return false;
    }

    public synchronized boolean addRotationModifier(@NotNull Predicate<RenderedBone> predicate, @NotNull Function<Quaternionf, Quaternionf> function) {
        if (predicate.test(this)) {
            this.rotationModifier = this.rotationModifier.andThen(function);
            return true;
        }
        return false;
    }

    public synchronized boolean addPositionModifier(@NotNull Predicate<RenderedBone> predicate, @NotNull Function<Vector3f, Vector3f> function) {
        if (predicate.test(this)) {
            this.positionModifier = this.positionModifier.andThen(function);
            return true;
        }
        return false;
    }

    public boolean rotate(@NotNull ModelRotation rotation2, @NotNull PacketBundler bundler) {
        this.rotation = rotation2;
        if (this.display != null) {
            this.display.rotate(rotation2, bundler);
            return true;
        }
        return false;
    }

    public boolean tick() {
        return this.globalState.tick();
    }

    public boolean tick(@NotNull UUID uuid) {
        BoneStateHandler get = this.perPlayerState.get(uuid);
        return get != null && get.tick();
    }

    public void dirtyUpdate(@NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null) {
            d.sendDirtyEntityData(bundler);
        }
    }

    public void forceUpdate(boolean showItem, @NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null) {
            d.sendEntityData(showItem, bundler);
        }
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null) {
            d.sendEntityData(!d.invisible(), bundler);
        }
    }

    public void sendTransformation(@Nullable UUID uuid, @NotNull PacketBundler bundler) {
        this.state(uuid).sendTransformation(bundler);
    }

    public void forceTransformation(@NotNull PacketBundler bundler) {
        DisplayTransformer d = this.globalState.transformer;
        if (d != null) {
            d.sendTransformation(bundler);
        }
    }

    public int interpolationDuration() {
        return this.globalState.interpolationDuration();
    }

    @NotNull
    public Vector3f worldPosition() {
        return this.worldPosition(EMPTY_VECTOR);
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f localOffset) {
        return this.worldPosition(localOffset, EMPTY_VECTOR);
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f localOffset, @NotNull Vector3f globalOffset) {
        return this.worldPosition(localOffset, globalOffset, null);
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f localOffset, @NotNull Vector3f globalOffset, @Nullable UUID uuid) {
        BoneStateHandler state = this.state(uuid);
        float progress = state.progress();
        BoneMovement current = state.current();
        BoneMovement before = state.before();
        return MathUtil.fma(InterpolationUtil.lerp(before.position(), current.position(), progress).add((Vector3fc)this.itemStack.offset()).add((Vector3fc)localOffset).rotate((Quaternionfc)MathUtil.toQuaternion(InterpolationUtil.lerp(before.rawRotation(), current.rawRotation(), progress))), InterpolationUtil.lerp(before.scale(), current.scale(), progress), globalOffset).add((Vector3fc)this.root.getGroup().getPosition()).mul(this.scale.getAsFloat()).rotateX(-this.rotation.radianX()).rotateY(-this.rotation.radianY());
    }

    @NotNull
    public Vector3f worldRotation() {
        return this.worldRotation(null);
    }

    @NotNull
    public Vector3f worldRotation(@Nullable UUID uuid) {
        BoneStateHandler state = this.state(uuid);
        float progress = state.progress();
        BoneMovement current = state.current();
        BoneMovement before = state.before();
        return InterpolationUtil.lerp(before.rawRotation(), current.rawRotation(), progress);
    }

    public void defaultPosition(@NotNull Supplier<Vector3f> movement) {
        this.defaultPosition = movement;
    }

    @NotNull
    private Vector3f modifiedPosition(boolean preventModifierUpdate) {
        return preventModifierUpdate ? this.lastModifiedPosition : (this.lastModifiedPosition = this.positionModifier.apply(new Vector3f()));
    }

    @NotNull
    private Quaternionf modifiedRotation(boolean preventModifierUpdate) {
        return preventModifierUpdate ? this.lastModifiedRotation : (this.lastModifiedRotation = this.rotationModifier.apply(new Quaternionf()));
    }

    public boolean tint(@NotNull Predicate<RenderedBone> predicate) {
        return this.tint(predicate, this.previousTint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tint(@NotNull Predicate<RenderedBone> predicate, int tint) {
        if (this.tint != tint && predicate.test(this)) {
            Object object = this.itemLock;
            synchronized (object) {
                if (this.tint == tint) {
                    return false;
                }
                this.previousTint = this.tint;
                this.tint = tint;
                return this.applyItem();
            }
        }
        return false;
    }

    private boolean applyItem() {
        if (this.display != null) {
            this.applyItem(this.display);
            return true;
        }
        return false;
    }

    private void applyItem(@NotNull ModelDisplay targetDisplay) {
        targetDisplay.item(this.itemStack.isAir() ? this.itemStack.itemStack() : (ItemStack)this.tintCacheMap.computeIfAbsent(this.tint, i -> BetterModel.nms().tint(this.itemStack.itemStack(), i)));
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.teleport(location, bundler);
        }
    }

    public void spawn(boolean hide, @NotNull PacketBundler bundler) {
        DisplayTransformer transformer;
        if (this.display != null) {
            this.display.spawn(!hide && !this.display.invisible(), bundler);
        }
        if ((transformer = this.globalState.transformer) != null) {
            transformer.sendTransformation(bundler);
        }
    }

    public boolean addAnimation(@NotNull AnimationPredicate filter, @NotNull BlueprintAnimation animator, @NotNull AnimationModifier modifier, @NotNull AnimationEventHandler eventHandler) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.name());
            if (get == null && modifier.override(animator.override()) && !filter.isChildren()) {
                return false;
            }
            AnimationIterator.Type type = modifier.type(animator.loop());
            AnimationIterator<AnimationMovement> iterator = get != null ? get.iterator(type) : animator.emptyIterator(type);
            this.getOrCreateState((Player)modifier.player()).state.addAnimation(animator.name(), iterator, modifier, eventHandler);
            return true;
        }
        return false;
    }

    public boolean replaceAnimation(@NotNull AnimationPredicate filter, @NotNull String target, @NotNull BlueprintAnimation animator, @NotNull AnimationModifier modifier) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.name());
            if (get == null && modifier.override(animator.override()) && !filter.isChildren()) {
                return false;
            }
            AnimationIterator.Type type = modifier.type(animator.loop());
            AnimationIterator<AnimationMovement> iterator = get != null ? get.iterator(type) : animator.emptyIterator(type);
            this.state((Player)modifier.player()).state.replaceAnimation(target, iterator, modifier);
            return true;
        }
        return false;
    }

    public boolean stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String name, @Nullable Player player) {
        return filter.test(this) && this.state((Player)player).state.stopAnimation(name);
    }

    public void remove(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.remove(bundler);
        }
        if (this.nametag != null) {
            this.nametag.remove(bundler);
        }
    }

    @NotNull
    public Stream<RenderedBone> flatten() {
        return this.flattenBones().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<RenderedBone> flattenBones() {
        if (this.flattenBones != null) {
            return this.flattenBones;
        }
        RenderedBone renderedBone = this;
        synchronized (renderedBone) {
            if (this.flattenBones != null) {
                return this.flattenBones;
            }
            LinkedHashSet set = Stream.concat(Stream.of(this), this.children.values().stream().flatMap(RenderedBone::flatten)).collect(Collectors.toCollection(LinkedHashSet::new));
            this.flattenBones = Collections.unmodifiableSet(set);
            return this.flattenBones;
        }
    }

    public void iterateTree(@NotNull Consumer<RenderedBone> boneConsumer) {
        boneConsumer.accept(this);
        for (RenderedBone value : this.children.values()) {
            value.iterateTree(boneConsumer);
        }
    }

    public boolean matchTree(@NotNull Predicate<RenderedBone> bonePredicate) {
        boolean result = bonePredicate.test(this);
        for (RenderedBone value : this.children.values()) {
            if (!value.matchTree(bonePredicate)) continue;
            result = true;
        }
        return result;
    }

    public boolean matchTree(@NotNull BonePredicate predicate, @NotNull BiPredicate<RenderedBone, BonePredicate> mapper) {
        boolean parentResult = mapper.test(this, predicate);
        BonePredicate childPredicate = predicate.children(parentResult);
        for (RenderedBone value : this.children.values()) {
            if (!value.matchTree(childPredicate, mapper)) continue;
            parentResult = true;
        }
        return parentResult;
    }

    public boolean matchTree(@NotNull AnimationPredicate predicate, @NotNull BiPredicate<RenderedBone, AnimationPredicate> mapper) {
        boolean parentResult = mapper.test(this, predicate);
        AnimationPredicate childPredicate = predicate;
        if (parentResult) {
            childPredicate = childPredicate.children();
        }
        for (RenderedBone value : this.children.values()) {
            if (!value.matchTree(childPredicate, mapper)) continue;
            parentResult = true;
        }
        return parentResult;
    }

    @NotNull
    public Vector3f hitBoxPosition() {
        NamedBoundingBox box = this.getGroup().getHitBox();
        if (box != null) {
            return this.worldPosition(box.centerPoint());
        }
        return this.worldPosition();
    }

    @NotNull
    public Quaternionf hitBoxViewRotation() {
        return MathUtil.toQuaternion(this.worldRotation()).rotateLocalX(-this.rotation.radianX()).rotateLocalY(-this.rotation.radianY());
    }

    public float hitBoxScale() {
        return this.scale.getAsFloat();
    }

    @NotNull
    public ModelRotation rotation() {
        return this.rotation;
    }

    @NotNull
    public BoneName name() {
        return this.getGroup().name();
    }

    @NotNull
    public UUID uuid() {
        return this.getGroup().uuid();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RenderedBone)) {
            return false;
        }
        RenderedBone bone = (RenderedBone)obj;
        return this.uuid().equals(bone.uuid());
    }

    public int hashCode() {
        return this.uuid().hashCode();
    }

    @NotNull
    @Generated
    public RendererGroup getGroup() {
        return this.group;
    }

    @NotNull
    @Generated
    public RenderedBone getRoot() {
        return this.root;
    }

    @Nullable
    @Generated
    public RenderedBone getParent() {
        return this.parent;
    }

    @NotNull
    @Generated
    public Map<BoneName, RenderedBone> getChildren() {
        return this.children;
    }

    @Generated
    public boolean isDummyBone() {
        return this.dummyBone;
    }

    @Nullable
    @Generated
    public ModelDisplay getDisplay() {
        return this.display;
    }

    @Nullable
    @Generated
    public HitBox getHitBox() {
        return this.hitBox;
    }

    @Nullable
    @Generated
    public ModelNametag getNametag() {
        return this.nametag;
    }

    @Generated
    public BoneItemMapper getItemMapper() {
        return this.itemMapper;
    }

    @Generated
    public void setItemMapper(BoneItemMapper itemMapper) {
        this.itemMapper = itemMapper;
    }

    final class BoneStateHandler {
        private boolean firstTick = true;
        private boolean skipInterpolation = false;
        private boolean sent;
        @Nullable
        private final UUID uuid;
        private final Consumer<UUID> consumer;
        private final AnimationStateHandler<AnimationMovement> state;
        private volatile BoneMovement beforeTransform;
        private volatile BoneMovement afterTransform;
        private final DisplayTransformer transformer;

        private BoneStateHandler(@NotNull UUID uuid, Consumer<UUID> consumer) {
            this.transformer = RenderedBone.this.display != null ? RenderedBone.this.display.createTransformer() : null;
            this.uuid = uuid;
            this.consumer = consumer;
            this.state = new AnimationStateHandler<AnimationMovement>(AnimationMovement.EMPTY, (b, a) -> {
                BoneStateHandler boneStateHandler = this;
                synchronized (boneStateHandler) {
                    this.skipInterpolation = false;
                    if (a != null && a.skipInterpolation()) {
                        RenderedBone.this.root.state((UUID)uuid).skipInterpolation = true;
                    }
                }
            });
        }

        @NotNull
        private BoneMovement before() {
            return this.beforeTransform != null ? this.beforeTransform : (this.beforeTransform = RenderedBone.this.defaultFrame);
        }

        @NotNull
        private BoneMovement current() {
            return this.afterTransform != null ? this.afterTransform : this.before();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        BoneMovement after() {
            if (this.afterTransform != null) {
                return this.afterTransform;
            }
            AnimationMovement keyframe = this.state.afterKeyframe();
            if (keyframe == null) {
                keyframe = AnimationMovement.EMPTY;
            }
            boolean preventModifierUpdate = this.interpolationDuration() < 1;
            BoneMovement def = RenderedBone.this.defaultFrame.plus(keyframe);
            if (RenderedBone.this.parent != null) {
                BoneMovement p = RenderedBone.this.parent.state(this.uuid).after();
                def = new BoneMovement(MathUtil.fma(def.position().rotate((Quaternionfc)p.rotation()), p.scale(), p.position()).sub((Vector3fc)RenderedBone.this.parent.lastModifiedPosition).add((Vector3fc)RenderedBone.this.modifiedPosition(preventModifierUpdate)), def.scale().mul((Vector3fc)p.scale()), (keyframe.globalRotation() ? new Quaternionf() : p.rotation().div((Quaternionfc)RenderedBone.this.parent.lastModifiedRotation, new Quaternionf())).mul((Quaternionfc)def.rotation()).mul((Quaternionfc)RenderedBone.this.modifiedRotation(preventModifierUpdate)), def.rawRotation());
            } else {
                def.position().add((Vector3fc)RenderedBone.this.modifiedPosition(preventModifierUpdate));
                def.rotation().mul((Quaternionfc)RenderedBone.this.modifiedRotation(preventModifierUpdate));
            }
            BoneStateHandler boneStateHandler = this;
            synchronized (boneStateHandler) {
                this.afterTransform = def;
                return this.afterTransform;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tick() {
            boolean result;
            boolean bl = result = this.state.tick(() -> {
                if (this.uuid != null) {
                    RenderedBone.this.perPlayerState.remove(this.uuid);
                    this.consumer.accept(this.uuid);
                }
            }) || this.firstTick;
            if (result) {
                BoneStateHandler boneStateHandler = this;
                synchronized (boneStateHandler) {
                    this.beforeTransform = this.afterTransform;
                    this.afterTransform = null;
                    this.sent = false;
                }
            }
            this.firstTick = false;
            return result;
        }

        private float progress() {
            return 1.0f - this.state.progress();
        }

        private int interpolationDuration() {
            if (RenderedBone.this.root.state((UUID)this.uuid).skipInterpolation) {
                return 0;
            }
            float frame = this.state.frame() / 5.0f;
            return Math.round(frame + 1.0E-5f);
        }

        private void sendTransformation(@NotNull PacketBundler bundler) {
            if (this.sent || this.transformer == null) {
                return;
            }
            this.sent = true;
            BoneMovement boneMovement = this.after();
            float mul = RenderedBone.this.scale.getAsFloat();
            this.transformer.transform(this.interpolationDuration(), MathUtil.fma(RenderedBone.this.itemStack.offset().rotate((Quaternionfc)boneMovement.rotation(), new Vector3f()).add((Vector3fc)boneMovement.position()).add((Vector3fc)RenderedBone.this.root.group.getPosition()), mul, RenderedBone.this.itemStack.position()).add((Vector3fc)RenderedBone.this.defaultPosition.get()), boneMovement.scale().mul((Vector3fc)RenderedBone.this.itemStack.scale(), new Vector3f()).mul(mul).max((Vector3fc)EMPTY_VECTOR), boneMovement.rotation(), bundler);
        }
    }
}

