/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kr.toxicity.model.api.BetterModelConfig;
import kr.toxicity.model.api.BetterModelPlugin;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.util.ReflectionUtil;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class BetterModel {
    public static final boolean IS_FOLIA = ReflectionUtil.classExists("io.papermc.paper.threadedregions.RegionizedServer");
    public static final boolean IS_PURPUR = ReflectionUtil.classExists("org.purpurmc.purpur.PurpurConfig");
    public static final boolean IS_PAPER = IS_PURPUR || IS_FOLIA || ReflectionUtil.classExists("io.papermc.paper.configuration.PaperConfigurations");
    private static BetterModelPlugin instance;

    private BetterModel() {
        throw new RuntimeException();
    }

    @NotNull
    public static BetterModelConfig config() {
        return BetterModel.plugin().config();
    }

    @NotNull
    public static Optional<ModelRenderer> model(@NotNull String name) {
        return Optional.ofNullable(BetterModel.modelOrNull(name));
    }

    @Nullable
    public static ModelRenderer modelOrNull(@NotNull String name) {
        return BetterModel.plugin().modelManager().model(name);
    }

    @NotNull
    public static Optional<ModelRenderer> limb(@NotNull String name) {
        return Optional.ofNullable(BetterModel.limbOrNull(name));
    }

    @Nullable
    public static ModelRenderer limbOrNull(@NotNull String name) {
        return BetterModel.plugin().modelManager().limb(name);
    }

    @NotNull
    public static Optional<PlayerChannelHandler> player(@NotNull UUID uuid) {
        return Optional.ofNullable(BetterModel.plugin().playerManager().player(uuid));
    }

    @NotNull
    public static Optional<EntityTrackerRegistry> registry(@NotNull UUID uuid) {
        return Optional.ofNullable(BetterModel.registryOrNull(uuid));
    }

    @NotNull
    public static Optional<EntityTrackerRegistry> registry(@NotNull Entity entity) {
        return Optional.ofNullable(BetterModel.registryOrNull(entity));
    }

    @Nullable
    public static EntityTrackerRegistry registryOrNull(@NotNull UUID uuid) {
        return EntityTrackerRegistry.registry(uuid);
    }

    @Nullable
    public static EntityTrackerRegistry registryOrNull(@NotNull Entity entity) {
        return EntityTrackerRegistry.registry(entity);
    }

    @NotNull
    public static @Unmodifiable Collection<ModelRenderer> models() {
        return BetterModel.plugin().modelManager().models();
    }

    @NotNull
    public static @Unmodifiable Collection<ModelRenderer> limbs() {
        return BetterModel.plugin().modelManager().limbs();
    }

    @NotNull
    public static @Unmodifiable Set<String> modelKeys() {
        return BetterModel.plugin().modelManager().modelKeys();
    }

    @NotNull
    public static @Unmodifiable Set<String> limbKeys() {
        return BetterModel.plugin().modelManager().limbKeys();
    }

    @NotNull
    public static BetterModelPlugin plugin() {
        return Objects.requireNonNull(instance, "BetterModel hasn't been initialized yet!");
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static BetterModelPlugin inst() {
        return BetterModel.plugin();
    }

    @ApiStatus.Internal
    public static void register(@NotNull BetterModelPlugin instance) {
        Objects.requireNonNull(instance, "instance cannot be null.");
        if (BetterModel.instance == instance) {
            throw new RuntimeException("Duplicated instance.");
        }
        BetterModel.instance = instance;
    }
}

