/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public record Float4(float dx, float dz, float tx, float tz) {
    public static final JsonDeserializer<Float4> PARSER = (json, typeOfT, context) -> {
        JsonArray array = json.getAsJsonArray();
        return new Float4(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat(), array.get(3).getAsFloat());
    };

    @NotNull
    public Float4 div(@NotNull ModelResolution resolution) {
        return this.div((float)resolution.width() / 16.0f, (float)resolution.height() / 16.0f);
    }

    @NotNull
    public Float4 div(float width, float height) {
        return new Float4(this.dx / width, this.dz / height, this.tx / width, this.tz / height);
    }

    @NotNull
    public JsonArray toJson() {
        JsonArray array = new JsonArray(4);
        array.add((Number)Float.valueOf(this.dx));
        array.add((Number)Float.valueOf(this.dz));
        array.add((Number)Float.valueOf(this.tx));
        array.add((Number)Float.valueOf(this.tz));
        return array;
    }

    @Override
    public int hashCode() {
        int hash = 31;
        int value = 1;
        value = value * hash + MathUtil.similarHashCode(this.dx);
        value = value * hash + MathUtil.similarHashCode(this.dz);
        value = value * hash + MathUtil.similarHashCode(this.tx);
        value = value * hash + MathUtil.similarHashCode(this.tz);
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        float dx1;
        float f;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Float4)) return false;
        Float4 float4 = (Float4)obj;
        try {
            dx1 = f = float4.dx();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        float dz1 = f = float4.dz();
        float tx1 = f = float4.tx();
        float tz1 = f = float4.tz();
        if (!MathUtil.isSimilar(this.dx, dx1)) return false;
        if (!MathUtil.isSimilar(this.dz, dz1)) return false;
        if (!MathUtil.isSimilar(this.tx, tx1)) return false;
        if (!MathUtil.isSimilar(this.tz, tz1)) return false;
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return this.toJson().toString();
    }
}

