/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.entity;

import java.util.Optional;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.entity.BaseBukkitEntity;
import kr.toxicity.model.api.nms.Identifiable;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.util.TransformedItemStack;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public interface BaseEntity
extends Identifiable,
PersistentDataHolder {
    @NotNull
    public static BaseBukkitEntity of(@NotNull Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PlayerChannelHandler channel = BetterModel.plugin().playerManager().player(player.getUniqueId());
            if (channel != null) {
                return channel.base();
            }
        }
        return BetterModel.nms().adapt(entity);
    }

    @Nullable
    public Component customName();

    @NotNull
    public Object handle();

    @Override
    public int id();

    public boolean dead();

    public boolean ground();

    public boolean invisible();

    public boolean glow();

    public boolean onWalk();

    public boolean fly();

    public double scale();

    public float pitch();

    public float bodyYaw();

    public float headYaw();

    public float damageTick();

    public float walkSpeed();

    @NotNull
    public Vector3f passengerPosition();

    @NotNull
    public Stream<Player> trackedBy();

    @NotNull
    public Location location();

    @NotNull
    public TransformedItemStack mainHand();

    @NotNull
    public TransformedItemStack offHand();

    @NotNull
    default public Optional<EntityTrackerRegistry> registry() {
        return BetterModel.registry(this.uuid());
    }

    default public boolean hasControllingPassenger() {
        EntityTrackerRegistry registry = this.registry().orElse(null);
        return registry != null && registry.hasControllingPassenger();
    }

    default public boolean hasModelData() {
        return this.modelData() != null;
    }

    @Nullable
    default public String modelData() {
        return (String)this.getPersistentDataContainer().get(EntityTrackerRegistry.TRACKING_ID, PersistentDataType.STRING);
    }

    default public void modelData(@Nullable String modelData) {
        PersistentDataContainer container = this.getPersistentDataContainer();
        if (modelData == null) {
            container.remove(EntityTrackerRegistry.TRACKING_ID);
        } else {
            container.set(EntityTrackerRegistry.TRACKING_ID, PersistentDataType.STRING, (Object)modelData);
        }
    }
}

