/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.AnimationPredicate;
import kr.toxicity.model.api.animation.AnimationStateHandler;
import kr.toxicity.model.api.animation.RunningAnimation;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.script.AnimationScript;
import kr.toxicity.model.api.script.BlueprintScript;
import kr.toxicity.model.api.script.TimeScript;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.function.BonePredicate;
import kr.toxicity.model.api.util.function.FloatSupplier;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class RenderPipeline {
    private final ModelRenderer parent;
    private final RenderSource<?> source;
    private final Map<BoneName, RenderedBone> boneMap;
    private final Map<String, BlueprintAnimation> animationMap;
    private final List<RenderedBone> bones;
    private final int displayAmount;
    private final Map<UUID, PlayerChannelHandler> playerMap = new ConcurrentHashMap<UUID, PlayerChannelHandler>();
    private final Set<UUID> hidePlayerSet = ConcurrentHashMap.newKeySet();
    private Predicate<Player> viewFilter = p -> true;
    private Predicate<Player> hideFilter = p -> this.hidePlayerSet.contains(p.getUniqueId());
    private Consumer<PacketBundler> spawnPacketHandler = b -> {};
    private Consumer<PacketBundler> despawnPacketHandler = b -> {};
    private Consumer<PacketBundler> hidePacketHandler = b -> {};
    private Consumer<PacketBundler> showPacketHandler = b -> {};
    private ModelRotation rotation = ModelRotation.INVALID;
    private final AnimationStateHandler<TimeScript> scriptProcessor = new AnimationStateHandler<TimeScript>(TimeScript.EMPTY, (a, s, t) -> s == AnimationStateHandler.MappingState.PROGRESS ? a.time(t) : AnimationScript.EMPTY.time(t), s -> {
        if (s == null) {
            return;
        }
        if (s.isSync()) {
            BetterModel.plugin().scheduler().task(this.getSource().location(), () -> s.accept(this.getSource()));
        } else {
            s.accept(this.getSource());
        }
    });

    public RenderPipeline(@NotNull ModelRenderer parent, @NotNull RenderSource<?> source, @NotNull Map<BoneName, RenderedBone> boneMap) {
        this.parent = parent;
        this.source = source;
        this.boneMap = boneMap;
        this.animationMap = parent.animationMap();
        this.bones = boneMap.values().stream().flatMap(RenderedBone::flatten).toList();
        this.displayAmount = (int)this.bones.stream().filter(rb -> rb.getDisplay() != null).count();
    }

    @NotNull
    public PacketBundler createBundler() {
        return BetterModel.plugin().nms().createBundler(this.displayAmount);
    }

    @NotNull
    public PacketBundler createLazyBundler() {
        return BetterModel.plugin().nms().createLazyBundler();
    }

    @NotNull
    public PacketBundler createParallelBundler() {
        return BetterModel.plugin().nms().createParallelBundler(BetterModel.config().packetBundlingSize());
    }

    public void viewFilter(@NotNull Predicate<Player> filter) {
        this.viewFilter = this.viewFilter.and(Objects.requireNonNull(filter));
    }

    public void hideFilter(@NotNull Predicate<Player> filter) {
        this.hideFilter = this.hideFilter.and(Objects.requireNonNull(filter));
    }

    public void spawnPacketHandler(@NotNull Consumer<PacketBundler> spawnPacketHandler) {
        this.spawnPacketHandler = this.spawnPacketHandler.andThen(Objects.requireNonNull(spawnPacketHandler));
    }

    public void despawnPacketHandler(@NotNull Consumer<PacketBundler> despawnPacketHandler) {
        this.despawnPacketHandler = this.despawnPacketHandler.andThen(Objects.requireNonNull(despawnPacketHandler));
    }

    public void hidePacketHandler(@NotNull Consumer<PacketBundler> despawnPacketHandler) {
        this.hidePacketHandler = this.hidePacketHandler.andThen(Objects.requireNonNull(despawnPacketHandler));
    }

    public void showPacketHandler(@NotNull Consumer<PacketBundler> despawnPacketHandler) {
        this.showPacketHandler = this.showPacketHandler.andThen(Objects.requireNonNull(despawnPacketHandler));
    }

    public boolean isSpawned(@NotNull UUID uuid) {
        return this.playerMap.containsKey(uuid);
    }

    public boolean isSpawned(@NotNull Player player) {
        return this.isSpawned(player.getUniqueId());
    }

    @Nullable
    public RunningAnimation runningAnimation() {
        for (RenderedBone value : this.boneMap.values()) {
            RunningAnimation get = value.findNotNullByTree(RenderedBone::runningAnimation);
            if (get == null) continue;
            return get;
        }
        return null;
    }

    @NotNull
    public String name() {
        return this.parent.name();
    }

    public void despawn() {
        this.hitboxes().forEach(HitBox::removeHitBox);
        PacketBundler bundler = this.createBundler();
        this.remove0(bundler);
        if (bundler.isNotEmpty()) {
            this.allPlayer().forEach(bundler::send);
        }
        this.playerMap.clear();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        this.iterateTree(b -> b.teleport(location, bundler));
    }

    public boolean rotate(@NotNull ModelRotation rotation, @NotNull PacketBundler bundler) {
        if (rotation.equals(this.rotation)) {
            return false;
        }
        this.rotation = rotation;
        return this.matchTree(b -> b.rotate(rotation, bundler));
    }

    public boolean tick(@NotNull PacketBundler bundler) {
        boolean script = this.scriptProcessor.tick();
        return this.matchTree(b -> b.tick(bundler)) || script;
    }

    public void defaultPosition(@NotNull Supplier<Vector3f> movement) {
        this.iterateTree(b -> b.defaultPosition(movement));
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        this.iterateTree(b -> b.forceUpdate(bundler));
    }

    public void forceUpdate(boolean showItem, @NotNull PacketBundler bundler) {
        this.iterateTree(b -> b.forceUpdate(showItem, bundler));
    }

    public void scale(@NotNull FloatSupplier scale) {
        this.iterateTree(b -> b.scale(scale));
    }

    public boolean addRotationModifier(@NotNull BonePredicate predicate, @NotNull Function<Quaternionf, Quaternionf> mapper) {
        return this.matchTree(predicate, (RenderedBone b, BonePredicate p) -> b.addRotationModifier((Predicate<RenderedBone>)p, mapper));
    }

    public boolean addPositionModifier(@NotNull BonePredicate predicate, @NotNull Function<Vector3f, Vector3f> mapper) {
        return this.matchTree(predicate, (RenderedBone b, BonePredicate p) -> b.addPositionModifier((Predicate<RenderedBone>)p, mapper));
    }

    @NotNull
    public @Unmodifiable List<RenderedBone> bones() {
        return this.bones;
    }

    @NotNull
    public Stream<HitBox> hitboxes() {
        return this.bones().stream().map(RenderedBone::getHitBox).filter(Objects::nonNull);
    }

    @Nullable
    public RenderedBone boneOf(@NotNull Predicate<RenderedBone> predicate) {
        for (RenderedBone value : this.boneMap.values()) {
            RenderedBone get = value.boneOf(predicate);
            if (get == null) continue;
            return get;
        }
        return null;
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        return this.animate(filter, get, modifier, removeTask);
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull BlueprintAnimation animation, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        BlueprintScript script = animation.script(modifier);
        if (script != null) {
            this.scriptProcessor.addAnimation(animation.name(), script.iterator(), modifier, () -> {});
        }
        Runnable playOnceTask = FunctionUtil.playOnce(removeTask);
        return this.matchTree(AnimationPredicate.of(filter), (RenderedBone b, AnimationPredicate a) -> b.addAnimation((AnimationPredicate)a, animation, modifier, playOnceTask));
    }

    public boolean replace(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation, @NotNull AnimationModifier modifier) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        return this.replace(filter, target, get, modifier);
    }

    public boolean replace(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull BlueprintAnimation animation, @NotNull AnimationModifier modifier) {
        BlueprintScript script = animation.script(modifier);
        if (script != null) {
            this.scriptProcessor.replaceAnimation(target, script.iterator(), modifier);
        }
        return this.matchTree(AnimationPredicate.of(filter), (RenderedBone b, AnimationPredicate a) -> b.replaceAnimation((AnimationPredicate)a, target, animation, modifier));
    }

    public boolean stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String target) {
        boolean script = this.scriptProcessor.stopAnimation(target);
        return this.matchTree(b -> b.stopAnimation(filter, target)) || script;
    }

    public boolean spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        PlayerChannelHandler get = BetterModel.plugin().playerManager().player(player.getUniqueId());
        if (get == null) {
            return false;
        }
        this.playerMap.put(player.getUniqueId(), get);
        this.spawnPacketHandler.accept(bundler);
        boolean hided = this.isHide(player);
        this.iterateTree(b -> b.spawn(hided, bundler));
        return true;
    }

    public boolean remove(@NotNull Player player) {
        if (this.playerMap.remove(player.getUniqueId()) == null) {
            return false;
        }
        PacketBundler bundler = this.createBundler();
        this.remove0(bundler);
        bundler.send(player);
        return true;
    }

    private void remove0(@NotNull PacketBundler bundler) {
        this.despawnPacketHandler.accept(bundler);
        this.iterateTree(b -> b.remove(bundler));
    }

    public boolean matchTree(@NotNull BonePredicate predicate, BiPredicate<RenderedBone, BonePredicate> mapper) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(mapper);
        boolean result = false;
        for (RenderedBone value : this.boneMap.values()) {
            if (!value.matchTree(predicate, mapper)) continue;
            result = true;
        }
        return result;
    }

    public boolean matchTree(@NotNull AnimationPredicate predicate, BiPredicate<RenderedBone, AnimationPredicate> mapper) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(mapper);
        boolean result = false;
        for (RenderedBone value : this.boneMap.values()) {
            if (!value.matchTree(predicate, mapper)) continue;
            result = true;
        }
        return result;
    }

    public boolean matchTree(@NotNull Predicate<RenderedBone> predicate) {
        Objects.requireNonNull(predicate);
        boolean result = false;
        for (RenderedBone value : this.boneMap.values()) {
            if (!value.matchTree(predicate)) continue;
            result = true;
        }
        return result;
    }

    public void iterateTree(@NotNull Consumer<RenderedBone> consumer) {
        Objects.requireNonNull(consumer);
        for (RenderedBone value : this.boneMap.values()) {
            value.iterateTree(consumer);
        }
    }

    public int playerCount() {
        return this.playerMap.size();
    }

    @NotNull
    public Stream<Player> allPlayer() {
        return this.playerMap.values().stream().map(PlayerChannelHandler::player);
    }

    @NotNull
    public Stream<Player> nonHidePlayer() {
        return this.filteredPlayer(p -> !this.isHide((Player)p));
    }

    @NotNull
    public Stream<Player> viewedPlayer() {
        return this.filteredPlayer(this.viewFilter);
    }

    @NotNull
    public Stream<Player> filteredPlayer(@NotNull Predicate<Player> predicate) {
        return this.allPlayer().filter(predicate);
    }

    public boolean hide(@NotNull Player player) {
        if (this.hidePlayerSet.add(player.getUniqueId())) {
            if (this.isSpawned(player)) {
                PacketBundler bundler = this.createBundler();
                this.forceUpdate(false, bundler);
                this.hidePacketHandler.accept(bundler);
                if (bundler.isNotEmpty()) {
                    bundler.send(player);
                }
            }
            BetterModel.plugin().scheduler().task((Entity)player, () -> this.hitboxes().forEach(hb -> hb.hide(player)));
            return true;
        }
        return false;
    }

    public boolean isHide(@NotNull Player player) {
        return this.hideFilter.test(player);
    }

    public boolean show(@NotNull Player player) {
        if (this.hidePlayerSet.remove(player.getUniqueId())) {
            if (this.isSpawned(player)) {
                PacketBundler bundler = this.createBundler();
                this.forceUpdate(true, bundler);
                this.showPacketHandler.accept(bundler);
                if (bundler.isNotEmpty()) {
                    bundler.send(player);
                }
            }
            BetterModel.plugin().scheduler().task((Entity)player, () -> this.hitboxes().forEach(hb -> hb.show(player)));
            return true;
        }
        return false;
    }

    @Generated
    public ModelRenderer getParent() {
        return this.parent;
    }

    @Generated
    public RenderSource<?> getSource() {
        return this.source;
    }

    @Generated
    public ModelRotation getRotation() {
        return this.rotation;
    }
}

