/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.ArrayList;
import java.util.List;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.AnimationPoint;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.data.raw.Datapoint;
import kr.toxicity.model.api.data.raw.ModelKeyframe;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.interpolation.VectorInterpolation;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;

public record BlueprintAnimator(@NotNull String name, @NotNull @Unmodifiable List<AnimationMovement> keyFrame) {
    @NotNull
    public AnimationIterator<AnimationMovement> iterator(@NotNull AnimationIterator.Type type) {
        return type.create(this.keyFrame);
    }

    public static final class Builder {
        private final float length;
        private final List<VectorPoint> transform = new ArrayList<VectorPoint>();
        private final List<VectorPoint> scale = new ArrayList<VectorPoint>();
        private final List<VectorPoint> rotation = new ArrayList<VectorPoint>();

        @NotNull
        public Builder addFrame(@NotNull ModelKeyframe keyframe) {
            if (keyframe.time() > this.length) {
                return this;
            }
            VectorInterpolation interpolation = keyframe.findInterpolation();
            for (Datapoint dataPoint : keyframe.dataPoints()) {
                Vector3f vec = dataPoint.toVector();
                switch (keyframe.channel()) {
                    case POSITION: {
                        this.transform.add(new VectorPoint(MathUtil.transformToDisplay(vec.div(16.0f)), keyframe.time(), interpolation));
                        break;
                    }
                    case ROTATION: {
                        this.rotation.add(new VectorPoint(MathUtil.animationToDisplay(vec), keyframe.time(), interpolation));
                        break;
                    }
                    case SCALE: {
                        this.scale.add(new VectorPoint(vec.sub(1.0f, 1.0f, 1.0f), keyframe.time(), interpolation));
                    }
                }
            }
            return this;
        }

        @NotNull
        public AnimatorData build(@NotNull String name) {
            return new AnimatorData(name, InterpolationUtil.sum(this.length, this.transform.stream().distinct().toList(), this.rotation.stream().distinct().toList(), this.scale.stream().distinct().toList()));
        }

        @Generated
        public Builder(float length) {
            this.length = length;
        }
    }

    public record AnimatorData(@NotNull String name, @NotNull List<AnimationPoint> points) {
    }
}

