/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.function.BonePredicate;
import org.bukkit.entity.Display;
import org.jetbrains.annotations.NotNull;

public interface TrackerUpdateAction<T extends ActionData> {
    public static final TrackerUpdateAction<Tint> TINT = t -> (b2, p) -> b2.tint((Predicate<RenderedBone>)p, t.rgb);
    public static final TrackerUpdateAction<Brightness> BRIGHTNESS = t -> (b2, p) -> b2.brightness((Predicate<RenderedBone>)p, t.block, t.sky);
    public static final TrackerUpdateAction<Glow> GLOW = t -> (b2, p) -> b2.glow((Predicate<RenderedBone>)p, t.glow, t.glowColor);
    public static final TrackerUpdateAction<Enchant> ENCHANT = t -> (b2, p) -> b2.enchant((Predicate<RenderedBone>)p, t == Enchant.TRUE);
    public static final TrackerUpdateAction<TogglePart> TOGGLE_PART = t -> (b2, p) -> b2.togglePart((Predicate<RenderedBone>)p, t == TogglePart.TRUE);
    public static final TrackerUpdateAction<ItemStack> ITEM_STACK = t -> (b2, p) -> b2.itemStack((Predicate<RenderedBone>)p, t.itemStack);
    public static final TrackerUpdateAction<Billboard> BILLBOARD = t -> (b2, p) -> b2.billboard((Predicate<RenderedBone>)p, t.billboard);

    @NotNull
    public TrackerActionCondition create(@NotNull T var1);

    @NotNull
    public static Brightness brightness(int block, int sky) {
        return new Brightness(block, sky);
    }

    @NotNull
    public static Glow glow(boolean glow, int glowColor) {
        return new Glow(glow, glowColor);
    }

    @NotNull
    public static Tint tint(int rgb) {
        return new Tint(rgb);
    }

    @NotNull
    public static Enchant enchant(boolean enchant) {
        return enchant ? Enchant.TRUE : Enchant.FALSE;
    }

    @NotNull
    public static TogglePart togglePart(boolean toggle) {
        return toggle ? TogglePart.TRUE : TogglePart.FALSE;
    }

    @NotNull
    public static ItemStack itemStack(@NotNull TransformedItemStack itemStack) {
        Objects.requireNonNull(itemStack);
        return new ItemStack(itemStack);
    }

    @NotNull
    public static Billboard billboard(@NotNull Display.Billboard billboard) {
        Objects.requireNonNull(billboard);
        return new Billboard(billboard);
    }

    public record Brightness(int block, int sky) implements ActionData
    {
    }

    public record Glow(boolean glow, int glowColor) implements ActionData
    {
    }

    public record Tint(int rgb) implements ActionData
    {
    }

    public static enum Enchant implements ActionData
    {
        TRUE,
        FALSE;

    }

    public static enum TogglePart implements ActionData
    {
        TRUE,
        FALSE;

    }

    public record ItemStack(@NotNull TransformedItemStack itemStack) implements ActionData
    {
    }

    public record Billboard(@NotNull Display.Billboard billboard) implements ActionData
    {
    }

    @FunctionalInterface
    public static interface TrackerActionCondition
    extends BiPredicate<RenderedBone, BonePredicate> {
    }

    public static sealed interface ActionData
    permits Brightness, Glow, Enchant, Tint, TogglePart, ItemStack, Billboard {
    }
}

