/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.function;

import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.Objects;
import java.util.function.Function;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.function.FloatConstantFunction;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface FloatFunction<T> {
    @NotNull
    public T apply(float var1);

    @NotNull
    public static <T> FloatConstantFunction<T> of(@NotNull T t) {
        return new FloatConstantFunction<T>(Objects.requireNonNull(t));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    default public <R> FloatFunction<R> map(@NotNull Function<T, R> mapper) {
        Object value;
        FloatFunction floatFunction = this;
        if (!(floatFunction instanceof FloatConstantFunction)) return f -> mapper.apply(this.apply(f));
        FloatConstantFunction floatConstantFunction = (FloatConstantFunction)floatFunction;
        try {
            Object t;
            value = t = floatConstantFunction.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return FloatFunction.of(mapper.apply(value));
    }

    @NotNull
    default public FloatFunction<T> memoize() {
        if (this instanceof FloatConstantFunction) {
            return this;
        }
        Int2ReferenceOpenHashMap map = new Int2ReferenceOpenHashMap();
        return f -> map.computeIfAbsent(MathUtil.similarHashCode(f), i -> this.apply(f));
    }
}

