/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import it.unimi.dsi.fastutil.floats.FloatAVLTreeSet;
import it.unimi.dsi.fastutil.floats.FloatComparators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationPoint;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.VectorInterpolation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@ApiStatus.Internal
public final class VectorUtil {
    private static final float FRAME_HASH = 0.031f;

    private VectorUtil() {
        throw new RuntimeException();
    }

    private static void point(@NotNull Collection<Float> target, List<VectorPoint> points) {
        for (VectorPoint point : points) {
            target.add(Float.valueOf(point.time()));
        }
    }

    @NotNull
    public static List<AnimationPoint> putAnimationPoint(@NotNull List<AnimationPoint> animations, @NotNull Collection<Float> points) {
        return VectorUtil.sum(animations.stream().map(AnimationPoint::position).distinct().toList(), animations.stream().map(AnimationPoint::rotation).distinct().toList(), animations.stream().map(AnimationPoint::scale).distinct().toList(), points);
    }

    @NotNull
    public static List<AnimationPoint> sum(float length, @NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation, @NotNull List<VectorPoint> scale) {
        FloatAVLTreeSet set = new FloatAVLTreeSet((Comparator)FloatComparators.NATURAL_COMPARATOR);
        set.add(length);
        VectorUtil.point((Collection<Float>)set, position);
        VectorUtil.point((Collection<Float>)set, scale);
        VectorUtil.point((Collection<Float>)set, rotation);
        VectorUtil.insertRotationFrame((Set<Float>)set, rotation);
        VectorUtil.insertLerpFrame((Set<Float>)set);
        return VectorUtil.sum(position, rotation, scale, (Collection<Float>)set);
    }

    @NotNull
    public static List<AnimationPoint> sum(@NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation, @NotNull List<VectorPoint> scale, Collection<Float> points) {
        ArrayList<AnimationPoint> list = new ArrayList<AnimationPoint>();
        List<VectorPoint> pp = VectorUtil.putPoint(position, points);
        List<VectorPoint> rp = VectorUtil.putPoint(rotation, points);
        List<VectorPoint> sp = VectorUtil.putPoint(scale, points);
        for (int i = 0; i < pp.size(); ++i) {
            list.add(new AnimationPoint(pp.get(i), rp.get(i), sp.get(i)));
        }
        return list;
    }

    @NotNull
    public static List<VectorPoint> putPoint(@NotNull List<VectorPoint> vectors, @NotNull Collection<Float> points) {
        if (vectors.isEmpty()) {
            return points.stream().map(t -> new VectorPoint(new Vector3f(), t.floatValue(), VectorInterpolation.LINEAR)).toList();
        }
        VectorPoint last = vectors.getLast();
        float length = last.time();
        int i = 0;
        VectorPoint p2 = vectors.getFirst();
        float t2 = p2.time();
        ArrayList<VectorPoint> newVectors = new ArrayList<VectorPoint>();
        for (float point : points) {
            while (i < vectors.size() - 1 && t2 < point) {
                p2 = vectors.get(++i);
                t2 = p2.time();
            }
            if (point > length) {
                newVectors.add(new VectorPoint(last.vector(), point, last.interpolation()));
                continue;
            }
            newVectors.add(point == t2 ? vectors.get(i) : p2.interpolation().interpolate(vectors, i, point));
        }
        if (t2 < length) {
            newVectors.addAll(vectors.subList(i, vectors.size()));
        }
        return newVectors;
    }

    public static void insertRotationFrame(@NotNull Set<Float> frames, @NotNull List<VectorPoint> vectorPoints) {
        for (int i = 0; i < vectorPoints.size() - 1; ++i) {
            VectorPoint before = vectorPoints.get(i);
            VectorPoint after = vectorPoints.get(i + 1);
            float angle = (float)Math.ceil(Math.toDegrees(MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(after.vector())).mul((Quaternionfc)MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(before.vector())).invert()).angle()) / 45.0);
            if (!(angle > 1.0f)) continue;
            for (float t = 1.0f; t < angle; t += 1.0f) {
                frames.add(Float.valueOf(VectorUtil.linear(before.time(), after.time(), t / angle)));
            }
        }
    }

    public static void insertLerpFrame(@NotNull Set<Float> frames) {
        VectorUtil.insertLerpFrame(frames, (float)BetterModel.inst().configManager().lerpFrameTime() / 20.0f);
    }

    public static void insertLerpFrame(@NotNull Set<Float> frames, float frame) {
        if (frame <= 0.0f) {
            return;
        }
        frame += 0.031f;
        ArrayList<Float> list = new ArrayList<Float>(frames);
        float init = 0.0f;
        Float initAfter = list.getFirst();
        while (true) {
            float f;
            init += frame;
            if (!(f < initAfter.floatValue())) break;
            frames.add(Float.valueOf(init));
        }
        block1: for (int i = 0; i < list.size() - 1; ++i) {
            Float before = list.get(i);
            Float after = list.get(i + 1);
            while (true) {
                Float f;
                before = Float.valueOf(before.floatValue() + frame);
                if (!(f.floatValue() < after.floatValue())) continue block1;
                frames.add(before);
            }
        }
    }

    public static float alpha(float p0, float p1, float alpha) {
        float div = p1 - p0;
        return div == 0.0f ? 0.0f : (alpha - p0) / div;
    }

    @NotNull
    public static Vector3f linear(@NotNull Vector3f p0, @NotNull Vector3f p1, float alpha) {
        return new Vector3f(VectorUtil.linear(p0.x, p1.x, alpha), VectorUtil.linear(p0.y, p1.y, alpha), VectorUtil.linear(p0.z, p1.z, alpha));
    }

    public static float linear(float p0, float p1, float alpha) {
        return Math.fma(p1 - p0, alpha, p0);
    }

    @NotNull
    public static Vector3f catmull_rom(@NotNull Vector3f p0, @NotNull Vector3f p1, @NotNull Vector3f p2, @NotNull Vector3f p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return new Vector3f(0.5f * (2.0f * p1.x + (-p0.x + p2.x) * t + (2.0f * p0.x - 5.0f * p1.x + 4.0f * p2.x - p3.x) * t2 + (-p0.x + 3.0f * p1.x - 3.0f * p2.x + p3.x) * t3), 0.5f * (2.0f * p1.y + (-p0.y + p2.y) * t + (2.0f * p0.y - 5.0f * p1.y + 4.0f * p2.y - p3.y) * t2 + (-p0.y + 3.0f * p1.y - 3.0f * p2.y + p3.y) * t3), 0.5f * (2.0f * p1.z + (-p0.z + p2.z) * t + (2.0f * p0.z - 5.0f * p1.z + 4.0f * p2.z - p3.z) * t2 + (-p0.z + 3.0f * p1.z - 3.0f * p2.z + p3.z) * t3));
    }
}

