/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import java.util.UUID;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.event.ModelInteractAtEvent;
import kr.toxicity.model.api.manager.EntityManager;
import kr.toxicity.model.api.manager.ReloadInfo;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.ModelInteractionHand;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.manager.EntityManagerImpl;
import kr.toxicity.model.manager.GlobalManagerImpl;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.util.EventsKt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lkr/toxicity/model/manager/EntityManagerImpl;", "Lkr/toxicity/model/api/manager/EntityManager;", "Lkr/toxicity/model/manager/GlobalManagerImpl;", "<init>", "()V", "start", "", "reload", "info", "Lkr/toxicity/model/api/manager/ReloadInfo;", "core"})
public final class EntityManagerImpl
implements EntityManager,
GlobalManagerImpl {
    @NotNull
    public static final EntityManagerImpl INSTANCE = new EntityManagerImpl();

    private EntityManagerImpl() {
    }

    @Override
    public void start() {
        if (BetterModel.IS_PAPER) {
            EventsKt.registerListener(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                public final void remove(EntityRemoveFromWorldEvent $this$remove) {
                    block1: {
                        Intrinsics.checkNotNullParameter($this$remove, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$remove.getEntity());
                        if (entityTracker == null) break block1;
                        EntityTracker it = entityTracker;
                        boolean bl = false;
                        if (!it.forRemoval()) {
                            it.despawn();
                        }
                    }
                }

                @EventHandler(priority=EventPriority.MONITOR)
                public final void add(EntityAddToWorldEvent $this$add) {
                    block0: {
                        Intrinsics.checkNotNullParameter($this$add, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$add.getEntity());
                        if (entityTracker == null) break block0;
                        entityTracker.refresh();
                    }
                }

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public final void jump(EntityJumpEvent $this$jump) {
                    block0: {
                        Intrinsics.checkNotNullParameter($this$jump, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker((Entity)$this$jump.getEntity());
                        if (entityTracker == null) break block0;
                        entityTracker.animate("jump");
                    }
                }
            });
        } else {
            EventsKt.registerListener(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR)
                public final void remove(EntityRemoveEvent $this$remove) {
                    block1: {
                        Intrinsics.checkNotNullParameter($this$remove, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$remove.getEntity());
                        if (entityTracker == null) break block1;
                        EntityTracker it = entityTracker;
                        boolean bl = false;
                        if (!it.forRemoval()) {
                            it.despawn();
                        }
                    }
                }

                @EventHandler(priority=EventPriority.MONITOR)
                public final void add(EntityPortalEvent $this$add) {
                    block2: {
                        Intrinsics.checkNotNullParameter($this$add, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker($this$add.getEntity());
                        if (entityTracker == null) break block2;
                        EntityTracker it = entityTracker;
                        boolean bl = false;
                        if (!it.forRemoval()) {
                            it.despawn();
                        }
                        if (!it.getAdapter().dead()) {
                            it.refresh();
                        }
                    }
                }

                @EventHandler(priority=EventPriority.MONITOR)
                public final void add(PlayerPortalEvent $this$add) {
                    block2: {
                        Intrinsics.checkNotNullParameter($this$add, "<this>");
                        EntityTracker entityTracker = EntityTracker.tracker((Entity)$this$add.getPlayer());
                        if (entityTracker == null) break block2;
                        EntityTracker it = entityTracker;
                        boolean bl = false;
                        if (!it.forRemoval()) {
                            it.despawn();
                        }
                        if (!it.getAdapter().dead()) {
                            it.refresh();
                        }
                    }
                }
            });
        }
        EventsKt.registerListener(new Listener(){

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void potion(EntityPotionEffectEvent $this$potion) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$potion, "<this>");
                    EntityTracker entityTracker = EntityTracker.tracker($this$potion.getEntity());
                    if (entityTracker == null) break block0;
                    entityTracker.updateBaseEntity();
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void dismount(EntityDismountEvent $this$dismount) {
                Intrinsics.checkNotNullParameter($this$dismount, "<this>");
                Entity entity = $this$dismount.getDismounted();
                Intrinsics.checkNotNullExpressionValue(entity, "getDismounted(...)");
                Entity e = entity;
                $this$dismount.setCancelled(e instanceof HitBox && (((HitBox)e).mountController().canFly() || !((HitBox)e).mountController().canDismountBySelf()) && !((HitBox)e).forceDismount());
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void interact(ModelInteractAtEvent $this$interact) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$interact), "<this>");
                if ($this$interact.getHand() == ModelInteractionHand.RIGHT) {
                    Entity previous = $this$interact.getPlayer().getVehicle();
                    if (previous instanceof HitBox && Intrinsics.areEqual(((HitBox)previous).source().getUniqueId(), $this$interact.getHitBox().source().getUniqueId()) && ((HitBox)previous).mountController().canDismountBySelf()) {
                        $this$interact.getHitBox().dismount((Entity)$this$interact.getPlayer());
                    } else if ($this$interact.getHitBox().mountController().canMount()) {
                        $this$interact.getHitBox().mount((Entity)$this$interact.getPlayer());
                    }
                }
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public final void quit(PlayerQuitEvent $this$quit) {
                block1: {
                    Intrinsics.checkNotNullParameter($this$quit, "<this>");
                    EntityTracker entityTracker = EntityTracker.tracker((Entity)$this$quit.getPlayer());
                    if (entityTracker != null) {
                        entityTracker.close();
                    }
                    Entity entity = $this$quit.getPlayer().getVehicle();
                    HitBox hitBox = entity instanceof HitBox ? (HitBox)entity : null;
                    if (hitBox == null) break block1;
                    hitBox.dismount((Entity)$this$quit.getPlayer());
                }
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public final void load(ChunkLoadEvent $this$load) {
                Intrinsics.checkNotNullParameter($this$load, "<this>");
                Entity[] entityArray = $this$load.getChunk().getEntities();
                Intrinsics.checkNotNullExpressionValue(entityArray, "getEntities(...)");
                Object[] $this$forEach$iv = entityArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl = false;
                    EntityTracker entityTracker = EntityTracker.tracker(it);
                    if (entityTracker == null) continue;
                    entityTracker.refresh();
                }
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public final void unload(ChunkUnloadEvent $this$unload) {
                Intrinsics.checkNotNullParameter($this$unload, "<this>");
                Entity[] entityArray = $this$unload.getChunk().getEntities();
                Intrinsics.checkNotNullExpressionValue(entityArray, "getEntities(...)");
                Object[] $this$forEach$iv = entityArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl = false;
                    EntityTracker entityTracker = EntityTracker.tracker(it);
                    if (entityTracker == null) continue;
                    entityTracker.despawn();
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void death(EntityDeathEvent $this$death) {
                block2: {
                    Intrinsics.checkNotNullParameter($this$death, "<this>");
                    EntityTracker entityTracker = EntityTracker.tracker((Entity)$this$death.getEntity());
                    if (entityTracker == null) break block2;
                    EntityTracker it = entityTracker;
                    boolean bl = false;
                    if (!it.animate("death", AnimationModifier.DEFAULT_WITH_PLAY_ONCE, () -> start.3.death$lambda$3$lambda$2(it))) {
                        it.close();
                    } else {
                        it.forRemoval(true);
                    }
                }
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public final void interact(PlayerInteractAtEntityEvent $this$interact) {
                block4: {
                    ModelInteractionHand modelInteractionHand;
                    Intrinsics.checkNotNullParameter($this$interact, "<this>");
                    Entity entity = $this$interact.getRightClicked();
                    HitBox hitBox = entity instanceof HitBox ? (HitBox)entity : null;
                    if (hitBox == null) break block4;
                    Player player = $this$interact.getPlayer();
                    switch (start.WhenMappings.$EnumSwitchMapping$0[$this$interact.getHand().ordinal()]) {
                        case 1: {
                            modelInteractionHand = ModelInteractionHand.RIGHT;
                            break;
                        }
                        case 2: {
                            modelInteractionHand = ModelInteractionHand.LEFT;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    hitBox.triggerInteractAt(player, modelInteractionHand, $this$interact.getClickedPosition());
                }
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public final void interact(PlayerInteractEntityEvent $this$interact) {
                block4: {
                    ModelInteractionHand modelInteractionHand;
                    Intrinsics.checkNotNullParameter($this$interact, "<this>");
                    Entity entity = $this$interact.getRightClicked();
                    HitBox hitBox = entity instanceof HitBox ? (HitBox)entity : null;
                    if (hitBox == null) break block4;
                    Player player = $this$interact.getPlayer();
                    switch (start.WhenMappings.$EnumSwitchMapping$0[$this$interact.getHand().ordinal()]) {
                        case 1: {
                            modelInteractionHand = ModelInteractionHand.RIGHT;
                            break;
                        }
                        case 2: {
                            modelInteractionHand = ModelInteractionHand.LEFT;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    hitBox.triggerInteract(player, modelInteractionHand);
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void damage(EntityDamageEvent $this$damage) {
                block2: {
                    Intrinsics.checkNotNullParameter($this$damage, "<this>");
                    if ($this$damage instanceof EntityDamageByEntityEvent) {
                        Entity $this$damage_u24lambda_u244 = ((EntityDamageByEntityEvent)$this$damage).getEntity();
                        boolean bl = false;
                        UUID uUID = $this$damage_u24lambda_u244 instanceof HitBox ? ((HitBox)$this$damage_u24lambda_u244).source().getUniqueId() : $this$damage_u24lambda_u244.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue(uUID, "run(...)");
                        UUID victim = uUID;
                        Entity v = ((EntityDamageByEntityEvent)$this$damage).getDamager().getVehicle();
                        if (v instanceof HitBox && !((HitBox)v).mountController().canBeDamagedByRider() && Intrinsics.areEqual(((HitBox)v).source().getUniqueId(), victim)) {
                            ((EntityDamageByEntityEvent)$this$damage).setCancelled(true);
                            return;
                        }
                    }
                    EntityTracker entityTracker = EntityTracker.tracker($this$damage.getEntity());
                    if (entityTracker == null) break block2;
                    EntityTracker it = entityTracker;
                    boolean bl = false;
                    it.animate("damage", AnimationModifier.DEFAULT_WITH_PLAY_ONCE);
                    it.damageTint();
                }
            }

            private static final void death$lambda$3$lambda$2(EntityTracker $it) {
                $it.close();
            }
        });
    }

    @Override
    public void reload(@NotNull ReloadInfo info) {
        Intrinsics.checkNotNullParameter(info, "info");
    }

    @Override
    public void end() {
        GlobalManagerImpl.DefaultImpls.end(this);
    }
}

