/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv;

import com.google.gson.JsonArray;
import org.jetbrains.annotations.NotNull;

public record ElementVector(float x, float y, float z) {
    public static final ElementVector CENTER = new ElementVector(8.0f, 8.0f, 8.0f);

    @NotNull
    public static ElementVector min(@NotNull ElementVector from, @NotNull ElementVector to) {
        return new ElementVector(Math.min(from.x(), to.x()), Math.min(from.y(), to.y()), Math.min(from.z(), to.z()));
    }

    @NotNull
    public static ElementVector max(@NotNull ElementVector from, @NotNull ElementVector to) {
        return new ElementVector(Math.max(from.x(), to.x()), Math.max(from.y(), to.y()), Math.max(from.z(), to.z()));
    }

    @NotNull
    public ElementVector plus(float x, float y, float z) {
        return new ElementVector(this.x + x, this.y + y, this.z + z);
    }

    @NotNull
    public ElementVector plus(@NotNull ElementVector vector) {
        return this.plus(vector.x, vector.y, vector.z);
    }

    @NotNull
    public ElementVector minus(float x, float y, float z) {
        return new ElementVector(this.x + x, this.y + y, this.z + z);
    }

    @NotNull
    public ElementVector minus(@NotNull ElementVector vector) {
        return this.minus(vector.x, vector.y, vector.z);
    }

    @NotNull
    public ElementVector toModelLocation() {
        return this.mul(16.0f);
    }

    @NotNull
    public ElementVector inflate(float inflate) {
        return new ElementVector(this.x + inflate / 8.0f, this.y + inflate / 8.0f, this.z + inflate / 8.0f);
    }

    @NotNull
    public ElementVector mul(float x, float y, float z) {
        return new ElementVector(this.x * x, this.y * y, this.z * z);
    }

    @NotNull
    public ElementVector div(float x, float y, float z) {
        return new ElementVector(this.x / x, this.y / y, this.z / z);
    }

    @NotNull
    public ElementVector mul(float scala) {
        return this.mul(scala, scala, scala);
    }

    @NotNull
    public ElementVector div(float scala) {
        return this.div(scala, scala, scala);
    }

    @NotNull
    public JsonArray asJson() {
        JsonArray array = new JsonArray(3);
        array.add((Number)Float.valueOf(this.x));
        array.add((Number)Float.valueOf(this.y));
        array.add((Number)Float.valueOf(this.z));
        return array;
    }

    @NotNull
    public ElementVector xz() {
        return new ElementVector(this.x, 0.0f, this.z);
    }

    @NotNull
    public ElementVector xy() {
        return new ElementVector(this.x, this.y, 0.0f);
    }

    @NotNull
    public ElementVector zy() {
        return new ElementVector(0.0f, this.y, this.z);
    }
}

