/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.ModelJson;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVByteBuilder;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVElement;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVIndexer;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVModelData;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVNamespace;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class UVModel {
    @NotNull
    private final Supplier<UVNamespace> namespace;
    @NotNull
    private final String modelName;
    private final List<UVElement> elements = new ArrayList<UVElement>();

    public UVModel(@NotNull UVNamespace namespace, @NotNull String modelName) {
        this(() -> namespace, modelName);
    }

    @NotNull
    public UVModel addElement(@NotNull UVElement element) {
        this.elements.add(element);
        return this;
    }

    @NotNull
    public String itemModelNamespace() {
        return this.namespace.get().asset(this.modelName);
    }

    @NotNull
    public List<UVByteBuilder> asJson(@NotNull String textureName) {
        UVIndexer indexer = new UVIndexer();
        ArrayList<UVByteBuilder> builderList = new ArrayList<UVByteBuilder>();
        JsonArray composite = new JsonArray();
        UVNamespace nSpace = this.namespace.get();
        String texture = nSpace.textureAssets(textureName);
        for (UVElement element : this.elements) {
            List<ModelJson> modelJson = element.pack(this.modelName, texture, indexer);
            for (JsonObject jsonObject : element.asJson(nSpace, indexer, modelJson)) {
                composite.add((JsonElement)jsonObject);
            }
            for (ModelJson json : modelJson) {
                builderList.add(json.builder(nSpace));
            }
        }
        JsonObject model = new JsonObject();
        model.addProperty("type", "minecraft:composite");
        model.add("models", (JsonElement)composite);
        JsonObject obj = new JsonObject();
        obj.add("model", (JsonElement)model);
        builderList.add(UVByteBuilder.of(nSpace.item(this.modelName), (JsonElement)obj));
        return builderList;
    }

    @NotNull
    public UVModelData write(@NotNull BufferedImage image) {
        UVModelData.Builder builder = UVModelData.builder();
        for (UVElement element : this.elements) {
            element.write(builder, image);
        }
        return builder.build();
    }

    @Generated
    public UVModel(@NotNull Supplier<UVNamespace> namespace, @NotNull String modelName) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        this.namespace = namespace;
        this.modelName = modelName;
    }
}

