/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.ModelBoundingBox;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.HitBoxSource;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.BonePredicate;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.VectorUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RenderedBone
implements HitBoxSource {
    @NotNull
    private final RendererGroup group;
    @Nullable
    private ModelDisplay display;
    private final BoneMovement defaultFrame;
    @NotNull
    private final RenderedBone root;
    @Nullable
    private final RenderedBone parent;
    @NotNull
    private final Map<String, RenderedBone> children;
    private final SequencedMap<String, TreeIterator> animators = new LinkedHashMap<String, TreeIterator>();
    private final Collection<TreeIterator> reversedView = this.animators.sequencedValues().reversed();
    private AnimationMovement keyFrame = null;
    private long delay = 0L;
    private TransformedItemStack cachedItem;
    private TransformedItemStack itemStack;
    private final List<Consumer<AnimationMovement>> movementModifier = new ArrayList<Consumer<AnimationMovement>>();
    @Nullable
    private HitBox hitBox;
    private final boolean dummyBone;
    private int tint;
    private TreeIterator currentIterator = null;
    private BoneMovement beforeTransform;
    private BoneMovement afterTransform;
    private BoneMovement relativeOffsetCache;
    private Supplier<Vector3f> defaultPosition = Vector3f::new;
    private ModelRotation rotation = ModelRotation.EMPTY;
    private Supplier<Float> scale = () -> Float.valueOf(1.0f);

    @ApiStatus.Internal
    public RenderedBone(@NotNull RendererGroup group, @Nullable RenderedBone parent, @NotNull TransformedItemStack itemStack, @NotNull ItemDisplay.ItemDisplayTransform transform, @NotNull Location firstLocation, @NotNull BoneMovement movement, @NotNull TrackerModifier modifier, @NotNull Function<RenderedBone, Map<String, RenderedBone>> childrenMapper) {
        this.group = group;
        this.parent = parent;
        RenderedBone r = this;
        while (r.getParent() != null) {
            r = r.getParent();
        }
        this.root = r;
        boolean visible = group.getLimb() != null || group.getParent().visibility();
        this.cachedItem = itemStack;
        this.itemStack = visible ? itemStack : itemStack.asAir();
        this.dummyBone = itemStack.isEmpty();
        if (!this.dummyBone) {
            this.display = BetterModel.inst().nms().create(firstLocation);
            this.display.display(transform);
            this.display.viewRange(modifier.viewRange());
            this.display.item(this.itemStack.itemStack());
        }
        this.defaultFrame = movement;
        this.children = Collections.unmodifiableMap(childrenMapper.apply(this));
    }

    @Nullable
    public String runningAnimation() {
        TreeIterator iterator2 = this.currentIterator;
        return iterator2 != null ? iterator2.name : null;
    }

    public boolean createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedBone> predicate, @Nullable HitBoxListener listener) {
        if (predicate.test(this)) {
            NamedBoundingBox h = this.group.getHitBox();
            if (h == null) {
                h = ModelBoundingBox.MIN.named(this.group.getName());
            }
            HitBoxListener l = listener;
            if (this.hitBox != null) {
                this.hitBox.removeHitBox();
                if (l == null) {
                    l = this.hitBox.listener();
                }
            }
            this.hitBox = BetterModel.inst().nms().createHitBox(entity, this, h, this.group.getMountController(), l != null ? l : HitBoxListener.EMPTY);
            return this.hitBox != null;
        }
        return false;
    }

    public boolean enchant(@NotNull BonePredicate predicate, boolean enchant) {
        if (predicate.test(this)) {
            this.itemStack = this.itemStack.modify(i -> {
                if (i.isEmpty()) {
                    return i;
                }
                ItemMeta meta = i.getItemMeta();
                if (enchant) {
                    meta.addEnchant(Enchantment.UNBREAKING, 0, true);
                } else {
                    meta.removeEnchant(Enchantment.UNBREAKING);
                }
                i.setItemMeta(meta);
                return i;
            });
            return this.applyItem();
        }
        return false;
    }

    public void scale(@NotNull Supplier<Float> scale) {
        this.scale = scale;
    }

    public boolean glow(@NotNull BonePredicate predicate, boolean glow, int glowColor) {
        if (predicate.test(this) && this.display != null) {
            this.display.glow(glow);
            this.display.glowColor(glowColor);
            return true;
        }
        return false;
    }

    public boolean itemStack(@NotNull BonePredicate predicate, @NotNull TransformedItemStack itemStack) {
        if (predicate.test(this)) {
            this.itemStack = this.cachedItem = itemStack;
            return this.applyItem();
        }
        return false;
    }

    public boolean brightness(@NotNull BonePredicate predicate, int block, int sky) {
        if (predicate.test(this) && this.display != null) {
            this.display.brightness(block, sky);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAnimationMovementModifier(@NotNull BonePredicate predicate, @NotNull Consumer<AnimationMovement> consumer) {
        if (predicate.test(this)) {
            List<Consumer<AnimationMovement>> list = this.movementModifier;
            synchronized (list) {
                this.movementModifier.add(consumer);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnimation() {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            Iterator<TreeIterator> iterator2 = this.reversedView.iterator();
            boolean check = true;
            while (iterator2.hasNext()) {
                TreeIterator next = iterator2.next();
                if (!next.get().booleanValue()) continue;
                if (this.currentIterator == null) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    this.currentIterator = next;
                    check = false;
                    break;
                }
                if (this.currentIterator != next) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    this.currentIterator.clear();
                    this.currentIterator = next;
                    this.delay = 0L;
                    check = false;
                    break;
                }
                if (this.delay <= 0L) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    check = false;
                    break;
                }
                check = false;
                break;
            }
            if (check) {
                this.keyFrame = null;
            }
        }
    }

    private boolean updateKeyframe(Iterator<TreeIterator> iterator2, TreeIterator next) {
        if (!next.hasNext()) {
            next.run();
            iterator2.remove();
            return false;
        }
        this.relativeOffsetCache = null;
        this.keyFrame = next.next();
        return true;
    }

    public boolean move(@Nullable ModelRotation rotation, @NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (rotation != null) {
            this.rotation = rotation;
            if (d != null) {
                d.rotate(rotation, bundler);
            }
        }
        --this.delay;
        this.updateAnimation();
        if (this.delay <= 0L) {
            int f = this.frame();
            this.delay = f;
            this.beforeTransform = this.afterTransform;
            BoneMovement entityMovement = this.afterTransform = this.relativeOffset();
            if (d != null) {
                d.frame(f <= 0 ? 0 : RenderedBone.toInterpolationDuration(f));
                this.setup(entityMovement);
                d.send(bundler);
                return true;
            }
        }
        return false;
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null && this.delay > 0L) {
            float speed = this.currentIterator != null ? this.currentIterator.deltaSpeed() : 1.0f;
            this.delay = Math.round((float)this.delay / speed);
            d.frame(RenderedBone.toInterpolationDuration(this.delay));
            d.send(bundler);
        }
    }

    private static int toInterpolationDuration(long delay) {
        return (int)Math.floor((float)delay / 5.0f) + 1;
    }

    @NotNull
    public Vector3f worldPosition() {
        return this.worldPosition(new Vector3f());
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f offset) {
        if (this.afterTransform != null) {
            float progress = 1.0f - this.progress();
            BoneMovement before = this.beforeTransform != null ? this.beforeTransform : BoneMovement.EMPTY;
            return VectorUtil.linear(before.transform(), this.afterTransform.transform(), progress).add((Vector3fc)this.itemStack.offset()).add((Vector3fc)offset).mul((Vector3fc)VectorUtil.linear(before.scale(), this.afterTransform.scale(), progress)).rotate((Quaternionfc)MathUtil.toQuaternion(MathUtil.blockBenchToDisplay(VectorUtil.linear(before.rawRotation(), this.afterTransform.rawRotation(), progress)))).add((Vector3fc)this.root.getGroup().getPosition()).mul(this.scale.get().floatValue()).rotateX((float)(-Math.toRadians(this.rotation.x()))).rotateY((float)(-Math.toRadians(this.rotation.y())));
        }
        return new Vector3f();
    }

    private void setup(@NotNull BoneMovement boneMovement) {
        if (this.display != null) {
            Float mul = this.scale.get();
            this.display.transform(new Transformation(new Vector3f((Vector3fc)boneMovement.transform()).add((Vector3fc)this.root.group.getPosition()).add((Vector3fc)new Vector3f((Vector3fc)this.itemStack.offset()).rotate((Quaternionfc)boneMovement.rotation())).mul(mul.floatValue()).add((Vector3fc)this.defaultPosition.get()), boneMovement.rotation(), new Vector3f((Vector3fc)boneMovement.scale()).mul((Vector3fc)this.itemStack.scale()).mul(mul.floatValue()), new Quaternionf()));
        }
    }

    public void defaultPosition(@NotNull Supplier<Vector3f> movement) {
        this.defaultPosition = this.group.getLimb() != null ? () -> new Vector3f((Vector3fc)movement.get()).add((Vector3fc)this.group.getLimb().getPosition()) : movement;
    }

    private int frame() {
        return this.keyFrame != null ? Math.round(this.keyFrame.time() * 100.0f) : (this.parent != null ? this.parent.frame() : 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BoneMovement defaultFrame() {
        AnimationMovement k = this.keyFrame != null ? this.keyFrame.copyNotNull() : new AnimationMovement(0.0f, new Vector3f(), new Vector3f(), new Vector3f());
        List<Consumer<AnimationMovement>> list = this.movementModifier;
        synchronized (list) {
            for (Consumer<AnimationMovement> consumer : this.movementModifier) {
                consumer.accept(k);
            }
        }
        return this.defaultFrame.plus(k);
    }

    private float progress() {
        int f = this.frame();
        return f == 0 ? 0.0f : (float)this.delay / (float)f;
    }

    private BoneMovement relativeOffset() {
        if (this.relativeOffsetCache != null) {
            return this.relativeOffsetCache;
        }
        BoneMovement def = this.defaultFrame();
        if (this.parent != null) {
            BoneMovement p = this.parent.relativeOffset();
            this.relativeOffsetCache = new BoneMovement(new Vector3f((Vector3fc)p.transform()).add((Vector3fc)new Vector3f((Vector3fc)def.transform()).mul((Vector3fc)p.scale()).rotate((Quaternionfc)p.rotation())), new Vector3f((Vector3fc)def.scale()).mul((Vector3fc)p.scale()), new Quaternionf((Quaternionfc)p.rotation()).mul((Quaternionfc)def.rotation()), def.rawRotation());
            return this.relativeOffsetCache;
        }
        this.relativeOffsetCache = def;
        return this.relativeOffsetCache;
    }

    public boolean tint(@NotNull BonePredicate predicate, int tint) {
        if (predicate.test(this)) {
            this.tint = tint;
            return this.applyItem();
        }
        return false;
    }

    private boolean applyItem() {
        if (this.display != null) {
            this.display.item(BetterModel.inst().nms().tint(this.itemStack.itemStack().clone(), this.tint));
            return true;
        }
        return false;
    }

    @NotNull
    public String getName() {
        return this.getGroup().getName();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.teleport(location, bundler);
        }
    }

    public void spawn(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.spawn(bundler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoop(@NotNull Predicate<RenderedBone> filter, @NotNull String parent, @NotNull BlueprintAnimation animator, AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            TreeIterator iterator2 = get != null ? new TreeIterator(parent, get.loopIterator(), modifier, removeTask) : new TreeIterator(parent, animator.emptyLoopIterator(), modifier, removeTask);
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.putLast(parent, iterator2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSingle(@NotNull Predicate<RenderedBone> filter, @NotNull String parent, @NotNull BlueprintAnimation animator, AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            TreeIterator iterator2 = get != null ? new TreeIterator(parent, get.singleIterator(), modifier, removeTask) : new TreeIterator(parent, animator.emptySingleIterator(), modifier, removeTask);
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.putLast(parent, iterator2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceLoop(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String parent, @NotNull BlueprintAnimation animator) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                TreeIterator v = (TreeIterator)this.animators.get(target);
                if (v != null) {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.loopIterator(), v.modifier, v.removeTask) : new TreeIterator(parent, animator.emptyLoopIterator(), v.modifier, v.removeTask));
                } else {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.loopIterator(), AnimationModifier.DEFAULT_LOOP, () -> {}) : new TreeIterator(parent, animator.emptyLoopIterator(), AnimationModifier.DEFAULT_LOOP, () -> {}));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSingle(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String parent, @NotNull BlueprintAnimation animator) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                TreeIterator v = (TreeIterator)this.animators.get(target);
                if (v != null) {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.singleIterator(), v.modifier, v.removeTask) : new TreeIterator(parent, animator.emptySingleIterator(), v.modifier, v.removeTask));
                } else {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.singleIterator(), AnimationModifier.DEFAULT, () -> {}) : new TreeIterator(parent, animator.emptySingleIterator(), AnimationModifier.DEFAULT, () -> {}));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String parent) {
        if (filter.test(this)) {
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.remove(parent);
            }
        }
    }

    public void remove(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.remove(bundler);
        }
    }

    public boolean togglePart(@NotNull BonePredicate predicate, boolean toggle) {
        if (predicate.test(this)) {
            this.itemStack = toggle ? this.cachedItem : this.cachedItem.asAir();
            return this.applyItem();
        }
        return false;
    }

    @Nullable
    public RenderedBone boneOf(@NotNull Predicate<RenderedBone> predicate) {
        return this.findNotNullByTree(b -> predicate.test((RenderedBone)b) ? b : null);
    }

    @Nullable
    public <T> T findNotNullByTree(@NotNull Function<RenderedBone, T> mapper) {
        T value = mapper.apply(this);
        if (value != null) {
            return value;
        }
        for (RenderedBone renderedBone : this.children.values()) {
            T childValue = renderedBone.findNotNullByTree(mapper);
            if (childValue == null) continue;
            return childValue;
        }
        return null;
    }

    public void iterateTree(@NotNull Consumer<RenderedBone> boneConsumer) {
        boneConsumer.accept(this);
        for (RenderedBone value : this.children.values()) {
            value.iterateTree(boneConsumer);
        }
    }

    public boolean matchTree(@NotNull Predicate<RenderedBone> bonePredicate) {
        boolean result = bonePredicate.test(this);
        for (RenderedBone value : this.children.values()) {
            if (!value.matchTree(bonePredicate)) continue;
            result = true;
        }
        return result;
    }

    public boolean iterateTree(@NotNull BonePredicate predicate, @NotNull BiPredicate<RenderedBone, BonePredicate> mapper) {
        boolean parentResult = mapper.test(this, predicate);
        BonePredicate childPredicate = predicate.children(parentResult);
        for (RenderedBone value : this.children.values()) {
            if (!value.iterateTree(childPredicate, mapper)) continue;
            parentResult = true;
        }
        return parentResult;
    }

    @Override
    @NotNull
    public Vector3f hitBoxPosition() {
        NamedBoundingBox box = this.getGroup().getHitBox();
        if (box != null) {
            return this.worldPosition(box.centerPoint().mul(-1.0f, 1.0f, -1.0f));
        }
        return this.worldPosition();
    }

    @Override
    @NotNull
    public ModelRotation hitBoxRotation() {
        return this.rotation;
    }

    public void despawn() {
        this.iterateTree(b -> {
            if (b.hitBox != null) {
                b.hitBox.removeHitBox();
            }
        });
    }

    @NotNull
    @Generated
    public RendererGroup getGroup() {
        return this.group;
    }

    @Nullable
    @Generated
    public ModelDisplay getDisplay() {
        return this.display;
    }

    @NotNull
    @Generated
    public RenderedBone getRoot() {
        return this.root;
    }

    @Nullable
    @Generated
    public RenderedBone getParent() {
        return this.parent;
    }

    @NotNull
    @Generated
    public Map<String, RenderedBone> getChildren() {
        return this.children;
    }

    @Nullable
    @Generated
    public HitBox getHitBox() {
        return this.hitBox;
    }

    @Generated
    public boolean isDummyBone() {
        return this.dummyBone;
    }

    private static class TreeIterator
    implements BlueprintAnimator.AnimatorIterator,
    Supplier<Boolean>,
    Runnable {
        private final String name;
        private final BlueprintAnimator.AnimatorIterator iterator;
        private final AnimationModifier modifier;
        private final Runnable removeTask;
        private boolean started = false;
        private boolean ended = false;
        private float cachedSpeed = 1.0f;

        public TreeIterator(String name, BlueprintAnimator.AnimatorIterator iterator2, AnimationModifier modifier, Runnable removeTask) {
            this.name = name;
            this.iterator = iterator2;
            this.modifier = modifier;
            this.removeTask = removeTask;
        }

        @Override
        @NotNull
        public AnimationMovement first() {
            return this.iterator.first();
        }

        @Override
        public int index() {
            return this.iterator.index();
        }

        @Override
        public int lastIndex() {
            return this.iterator.lastIndex();
        }

        @Override
        public void run() {
            this.removeTask.run();
        }

        @Override
        public Boolean get() {
            return this.modifier.predicate().get();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() || this.modifier.end() > 0 && !this.ended;
        }

        public float deltaSpeed() {
            float previous = this.cachedSpeed;
            this.cachedSpeed = this.modifier.speedValue();
            return this.cachedSpeed / previous;
        }

        @Override
        public AnimationMovement next() {
            if (!this.started) {
                this.started = true;
                return this.first().time((float)this.modifier.start() / 20.0f);
            }
            if (!this.iterator.hasNext()) {
                this.ended = true;
                return new AnimationMovement((float)this.modifier.end() / 20.0f, null, null, null);
            }
            AnimationMovement nxt = (AnimationMovement)this.iterator.next();
            this.cachedSpeed = this.modifier.speedValue();
            nxt = nxt.time(Math.max(nxt.time() / this.cachedSpeed, 0.01f));
            return nxt;
        }

        @Override
        public void clear() {
            this.iterator.clear();
            this.ended = !this.iterator.hasNext();
            this.started = this.ended;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeIterator that = (TreeIterator)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }
}

