/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3f;

public record ModelBoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
    public static final ModelBoundingBox MIN = ModelBoundingBox.of(0.1, 0.1, 0.1);

    @NotNull
    public static ModelBoundingBox of(@NotNull Vector3d min, @NotNull Vector3d max) {
        return new ModelBoundingBox(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    @NotNull
    public static ModelBoundingBox of(double x, double y, double z) {
        return new ModelBoundingBox(-x / 2.0, -y / 2.0, -z / 2.0, x / 2.0, y / 2.0, z / 2.0);
    }

    @NotNull
    public NamedBoundingBox named(@NotNull String name) {
        return new NamedBoundingBox(name, this);
    }

    public double x() {
        return this.maxX - this.minX;
    }

    public double y() {
        return this.maxY - this.minY;
    }

    public double z() {
        return this.maxZ - this.minZ;
    }

    @NotNull
    public Vector3f centerPoint() {
        return new Vector3f((float)(this.minX + this.maxX), (float)(this.minY + this.maxY), (float)(this.minZ + this.maxZ)).div(2.0f);
    }

    @NotNull
    public ModelBoundingBox times(double scale) {
        return new ModelBoundingBox(this.minX * scale, this.minY * scale, this.minZ * scale, this.maxX * scale, this.maxY * scale, this.maxZ * scale);
    }

    @NotNull
    public ModelBoundingBox center() {
        Vector3f center = this.centerPoint();
        return new ModelBoundingBox(this.minX - (double)center.x, this.minY - (double)center.y, this.minZ - (double)center.z, this.maxX - (double)center.x, this.maxY - (double)center.y, this.maxZ - (double)center.z);
    }

    @NotNull
    public Vector3d min() {
        return new Vector3d(this.minX, this.minY, this.minZ);
    }

    @NotNull
    public Vector3d max() {
        return new Vector3d(this.maxX, this.maxY, this.maxZ);
    }

    public double lengthZX() {
        return Math.sqrt(Math.pow(this.x(), 2.0) + Math.pow(this.z(), 2.0));
    }

    public double length() {
        return Math.sqrt(Math.pow(this.x(), 2.0) + Math.pow(this.y(), 2.0) + Math.pow(this.z(), 2.0));
    }
}

