/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import kr.toxicity.model.api.data.raw.Datapoint;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.Float4;
import kr.toxicity.model.api.data.raw.KeyframeChannel;
import kr.toxicity.model.api.data.raw.ModelAnimation;
import kr.toxicity.model.api.data.raw.ModelChildren;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.data.raw.ModelTexture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModelData(@NotNull ModelResolution resolution, @NotNull List<ModelElement> elements, @NotNull List<ModelChildren> outliner, @NotNull List<ModelTexture> textures, @Nullable List<ModelAnimation> animations) {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Float3.class, (json, typeOfT, context) -> Float3.PARSER.apply(json)).registerTypeAdapter(Float4.class, (json, typeOfT, context) -> Float4.PARSER.apply(json)).registerTypeAdapter(Datapoint.class, (json, typeOfT, context) -> Datapoint.PARSER.apply(json)).registerTypeAdapter(KeyframeChannel.class, (json, typeOfT, context) -> KeyframeChannel.valueOf(json.getAsString().toUpperCase())).registerTypeAdapter(ModelChildren.class, (json, typeOfT, context) -> ModelChildren.PARSER.apply(json)).create();

    public float scale() {
        return (float)this.elements().stream().mapToDouble(ModelElement::max).max().orElseThrow() / 16.0f;
    }
}

