/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.renderer.BlueprintRenderer;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.script.ScriptProcessor;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.util.BonePredicate;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Internal
public final class RenderInstance {
    private final BlueprintRenderer parent;
    private final Map<String, RenderedBone> entityMap;
    private final Map<String, BlueprintAnimation> animationMap;
    private final Map<UUID, PlayerChannelHandler> playerMap = new ConcurrentHashMap<UUID, PlayerChannelHandler>();
    private Predicate<Player> viewFilter = p -> true;
    private Predicate<Player> spawnFilter = OfflinePlayer::isOnline;
    private Consumer<PacketBundler> spawnPacketHandler = b -> {};
    private Consumer<PacketBundler> despawnPacketHandler = b -> {};
    private ModelRotation rotation = ModelRotation.EMPTY;
    private final ScriptProcessor scriptProcessor = new ScriptProcessor();

    public RenderInstance(@NotNull BlueprintRenderer parent, @NotNull Map<String, RenderedBone> entityMap, @NotNull Map<String, BlueprintAnimation> animationMap) {
        this.parent = parent;
        this.entityMap = entityMap;
        this.animationMap = animationMap;
        this.animateLoop("idle");
    }

    public void viewFilter(@NotNull Predicate<Player> filter) {
        this.viewFilter = this.viewFilter.and(FunctionUtil.throttleTick(filter));
    }

    public void spawnPacketHandler(@NotNull Consumer<PacketBundler> spawnPacketHandler) {
        this.spawnPacketHandler = this.spawnPacketHandler.andThen(spawnPacketHandler);
    }

    public void despawnPacketHandler(@NotNull Consumer<PacketBundler> despawnPacketHandler) {
        this.despawnPacketHandler = this.despawnPacketHandler.andThen(despawnPacketHandler);
    }

    @NotNull
    public Predicate<Player> spawnFilter() {
        return this.spawnFilter;
    }

    public void spawnFilter(@NotNull Predicate<Player> spawnFilter) {
        this.spawnFilter = this.spawnFilter.and(spawnFilter);
    }

    public void createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedBone> predicate, @Nullable HitBoxListener listener) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.createHitBox(entity, predicate, listener));
        }
    }

    @Nullable
    public String runningAnimation() {
        for (RenderedBone value : this.entityMap.values()) {
            String get = value.findNotNullByTree(RenderedBone::runningAnimation);
            if (get == null) continue;
            return get;
        }
        return null;
    }

    public void despawn() {
        for (RenderedBone value : this.entityMap.values()) {
            value.despawn();
        }
        PacketBundler bundler = BetterModel.inst().nms().createBundler();
        this.remove0(bundler);
        if (!bundler.isEmpty()) {
            for (PlayerChannelHandler value : this.playerMap.values()) {
                bundler.send(value.player());
            }
        }
        this.playerMap.clear();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.teleport(location, bundler));
        }
    }

    public boolean move(@Nullable ModelRotation rotation, @NotNull PacketBundler bundler) {
        ModelRotation rot = rotation == null || rotation.equals(this.rotation) ? null : (this.rotation = rotation);
        boolean match = false;
        for (RenderedBone value : this.entityMap.values()) {
            if (!value.matchTree(b -> b.move(rot, bundler))) continue;
            match = true;
        }
        return match;
    }

    public void defaultPosition(@NotNull Supplier<Vector3f> movement) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.defaultPosition(movement));
        }
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.forceUpdate(bundler));
        }
    }

    public void scale(@NotNull Supplier<Float> scale) {
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.scale(scale));
        }
    }

    public boolean itemStack(@NotNull BonePredicate predicate, @NotNull TransformedItemStack itemStack) {
        return this.anyMatch(predicate, (b, p) -> b.itemStack((BonePredicate)p, itemStack));
    }

    public boolean glow(@NotNull BonePredicate predicate, boolean glow, int glowColor) {
        return this.anyMatch(predicate, (b, p) -> b.glow((BonePredicate)p, glow, glowColor));
    }

    public boolean brightness(@NotNull BonePredicate predicate, int block, int sky) {
        return this.anyMatch(predicate, (b, p) -> b.brightness((BonePredicate)p, block, sky));
    }

    public boolean addAnimationMovementModifier(@NotNull BonePredicate predicate, @NotNull Consumer<AnimationMovement> consumer) {
        return this.anyMatch(predicate, (b, p) -> b.addAnimationMovementModifier((BonePredicate)p, consumer));
    }

    @NotNull
    public List<RenderedBone> bones() {
        ArrayList<RenderedBone> list = new ArrayList<RenderedBone>();
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(list::add);
        }
        return list;
    }

    @Nullable
    public RenderedBone boneOf(@NotNull Predicate<RenderedBone> predicate) {
        for (RenderedBone value : this.entityMap.values()) {
            RenderedBone get = value.boneOf(predicate);
            if (get == null) continue;
            return get;
        }
        return null;
    }

    public double height() {
        double h = 0.0;
        for (RenderedBone renderer : this.bones()) {
            float lt = renderer.worldPosition().y;
            if (renderer.getName().startsWith("h_")) {
                return lt;
            }
            if (!(h < (double)lt)) continue;
            h = lt;
        }
        return h;
    }

    public boolean tint(@NotNull BonePredicate predicate, int rgb) {
        return this.anyMatch(predicate, (b, p) -> b.tint((BonePredicate)p, rgb));
    }

    public boolean enchant(@NotNull BonePredicate predicate, boolean enchant) {
        return this.anyMatch(predicate, (b, p) -> b.enchant((BonePredicate)p, enchant));
    }

    public boolean animateLoop(@NotNull String animation) {
        return this.animateLoop(e -> true, animation, AnimationModifier.DEFAULT_LOOP, () -> {});
    }

    public boolean animateSingle(@NotNull String animation) {
        return this.animateSingle(e -> true, animation, AnimationModifier.DEFAULT, () -> {});
    }

    public boolean animateLoop(@NotNull String animation, AnimationModifier modifier) {
        return this.animateLoop(e -> true, animation, modifier, () -> {});
    }

    public boolean animateSingle(@NotNull String animation, AnimationModifier modifier) {
        return this.animateSingle(e -> true, animation, modifier, () -> {});
    }

    public boolean animateLoop(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.animateLoop(get.script(), modifier);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.addLoop(filter, animation, get, modifier, FunctionUtil.throttleTick(removeTask)));
        }
        return true;
    }

    public boolean animateSingle(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.animateSingle(get.script(), modifier);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.addSingle(filter, animation, get, modifier, FunctionUtil.throttleTick(removeTask)));
        }
        return true;
    }

    public boolean replaceLoop(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.replaceLoop(get.script(), AnimationModifier.DEFAULT_LOOP);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.replaceLoop(filter, target, animation, get));
        }
        return true;
    }

    public boolean replaceSingle(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation) {
        BlueprintAnimation get = this.animationMap.get(animation);
        if (get == null) {
            return false;
        }
        this.scriptProcessor.replaceSingle(get.script(), AnimationModifier.DEFAULT);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.replaceSingle(filter, target, animation, get));
        }
        return true;
    }

    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String target) {
        this.scriptProcessor.stopAnimation(target);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.stopAnimation(filter, target));
        }
    }

    public void spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        PlayerChannelHandler get = BetterModel.inst().playerManager().player(player.getUniqueId());
        if (get == null) {
            return;
        }
        if (this.playerMap.get(player.getUniqueId()) != null || this.spawnFilter.test(player)) {
            this.spawnPacketHandler.accept(bundler);
            for (RenderedBone value : this.entityMap.values()) {
                value.iterateTree(b -> b.spawn(bundler));
            }
            this.playerMap.put(player.getUniqueId(), get);
        }
    }

    public void remove(@NotNull Player player) {
        if (this.playerMap.remove(player.getUniqueId()) == null) {
            return;
        }
        PacketBundler bundler = BetterModel.inst().nms().createBundler();
        this.remove0(bundler);
        bundler.send(player);
    }

    private void remove0(@NotNull PacketBundler bundler) {
        this.despawnPacketHandler.accept(bundler);
        for (RenderedBone value : this.entityMap.values()) {
            value.iterateTree(b -> b.remove(bundler));
        }
    }

    public boolean togglePart(@NotNull BonePredicate predicate, boolean toggle) {
        return this.anyMatch(predicate, (b, p) -> b.togglePart((BonePredicate)p, toggle));
    }

    private boolean anyMatch(@NotNull BonePredicate predicate, BiPredicate<RenderedBone, BonePredicate> mapper) {
        boolean result = false;
        for (RenderedBone value : this.entityMap.values()) {
            if (!value.iterateTree(predicate, mapper)) continue;
            result = true;
        }
        return result;
    }

    public int playerCount() {
        return this.playerMap.size();
    }

    @NotNull
    public Stream<PlayerChannelHandler> allPlayer() {
        return this.playerMap.values().stream();
    }

    @NotNull
    public Stream<Player> viewedPlayer() {
        return this.viewedPlayer(this.viewFilter);
    }

    @NotNull
    public Stream<Player> viewedPlayer(@NotNull Predicate<Player> predicate) {
        return this.allPlayer().map(PlayerChannelHandler::player).filter(predicate);
    }

    @Generated
    public BlueprintRenderer getParent() {
        return this.parent;
    }

    @Generated
    public ModelRotation getRotation() {
        return this.rotation;
    }

    @Generated
    public ScriptProcessor getScriptProcessor() {
        return this.scriptProcessor;
    }
}

