/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SequencedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.AnimationPredicate;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.ModelBoundingBox;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.HitBoxSource;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.VectorUtil;
import kr.toxicity.model.api.util.function.BonePredicate;
import kr.toxicity.model.api.util.function.FloatSupplier;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RenderedBone
implements HitBoxSource {
    private static final Vector3f EMPTY_VECTOR = new Vector3f();
    private static final ItemStack AIR = new ItemStack(Material.AIR);
    @NotNull
    private final RendererGroup group;
    private final BoneMovement defaultFrame;
    @NotNull
    private final RenderedBone root;
    @Nullable
    private final RenderedBone parent;
    @NotNull
    private final Map<BoneName, RenderedBone> children;
    private final SequencedMap<String, TreeIterator> animators = new LinkedHashMap<String, TreeIterator>();
    private final Collection<TreeIterator> reversedView = this.animators.sequencedValues().reversed();
    private final Int2ObjectOpenHashMap<ItemStack> tintCacheMap = new Int2ObjectOpenHashMap();
    private final AtomicBoolean forceUpdateAnimation = new AtomicBoolean();
    private final boolean dummyBone;
    private final Object itemLock = new Object();
    @Nullable
    private ModelDisplay display;
    @Nullable
    private HitBox hitBox;
    private BoneItemMapper itemMapper;
    private int previousTint;
    private int tint = 0xFFFFFF;
    private TransformedItemStack itemStack;
    private boolean firstTick = true;
    private AnimationMovement keyFrame = null;
    private volatile long delay = 0L;
    private TreeIterator currentIterator = null;
    private BoneMovement beforeTransform;
    private BoneMovement afterTransform;
    private BoneMovement relativeOffsetCache;
    private ModelRotation rotation = ModelRotation.EMPTY;
    private Supplier<Vector3f> defaultPosition = FunctionUtil.asSupplier(new Vector3f());
    private FloatSupplier scale = () -> 1.0f;
    private Function<Vector3f, Vector3f> positionModifier = p -> p;
    private Vector3f lastModifiedPosition = new Vector3f();
    private Function<Quaternionf, Quaternionf> rotationModifier = r -> r;
    private Quaternionf lastModifiedRotation = new Quaternionf();

    @ApiStatus.Internal
    public RenderedBone(@NotNull RendererGroup group, @Nullable RenderedBone parent, @NotNull TransformedItemStack itemStack, @NotNull ItemDisplay.ItemDisplayTransform transform, @NotNull Location firstLocation, @NotNull BoneMovement movement, @NotNull TrackerModifier modifier, @NotNull Function<RenderedBone, Map<BoneName, RenderedBone>> childrenMapper) {
        this.group = group;
        this.parent = parent;
        this.itemMapper = group.getItemMapper();
        this.root = parent != null ? parent.root : this;
        this.itemStack = itemStack;
        this.dummyBone = itemStack.isAir();
        if (!this.dummyBone) {
            this.display = BetterModel.plugin().nms().create(firstLocation);
            this.display.display(transform);
            this.display.viewRange(modifier.viewRange());
            this.display.invisible(this.itemMapper == BoneItemMapper.EMPTY && !group.getParent().visibility());
        }
        this.defaultFrame = movement;
        this.children = Collections.unmodifiableMap(childrenMapper.apply(this));
        this.applyItem();
    }

    @Nullable
    public RunningAnimation runningAnimation() {
        TreeIterator iterator2 = this.currentIterator;
        return iterator2 != null ? iterator2.animation : null;
    }

    public boolean updateItem(@NotNull Predicate<RenderedBone> predicate, @NotNull RenderSource source) {
        return this.itemStack(predicate, (TransformedItemStack)this.itemMapper.apply(source, this.itemStack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedBone> predicate, @Nullable HitBoxListener listener) {
        if (predicate.test(this)) {
            HitBox previous = this.hitBox;
            RenderedBone renderedBone = this;
            synchronized (renderedBone) {
                if (previous != this.hitBox) {
                    return false;
                }
                NamedBoundingBox h = this.group.getHitBox();
                if (h == null) {
                    h = ModelBoundingBox.MIN.named(this.group.getName());
                }
                HitBoxListener l = listener;
                if (this.hitBox != null) {
                    this.hitBox.removeHitBox();
                    if (l == null) {
                        l = this.hitBox.listener();
                    }
                }
                this.hitBox = BetterModel.plugin().nms().createHitBox(entity, this, h, this.group.getMountController(), l != null ? l : HitBoxListener.EMPTY);
                return this.hitBox != null;
            }
        }
        return false;
    }

    public boolean enchant(@NotNull Predicate<RenderedBone> predicate, boolean enchant) {
        return this.itemStack(predicate, this.itemStack.modify(i -> {
            ItemMeta meta = i.getItemMeta();
            if (enchant) {
                meta.addEnchant(Enchantment.UNBREAKING, 0, true);
            } else {
                meta.removeEnchant(Enchantment.UNBREAKING);
            }
            i.setItemMeta(meta);
            return i;
        }));
    }

    public void moveDuration(int duration) {
        if (this.display != null) {
            this.display.moveDuration(duration);
        }
    }

    public void scale(@NotNull FloatSupplier scale) {
        this.scale = scale;
    }

    public boolean glow(@NotNull Predicate<RenderedBone> predicate, boolean glow, int glowColor) {
        if (this.display != null && predicate.test(this)) {
            this.display.glow(glow);
            this.display.glowColor(glowColor);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean itemStack(@NotNull Predicate<RenderedBone> predicate, @NotNull TransformedItemStack itemStack) {
        if (this.itemStack != itemStack && predicate.test(this)) {
            Object object = this.itemLock;
            synchronized (object) {
                if (this.itemStack == itemStack) {
                    return false;
                }
                this.itemStack = itemStack;
                if (this.display != null) {
                    this.display.invisible(itemStack.isAir());
                }
                this.tintCacheMap.clear();
                return this.applyItem();
            }
        }
        return false;
    }

    public boolean brightness(@NotNull Predicate<RenderedBone> predicate, int block, int sky) {
        if (this.display != null && predicate.test(this)) {
            this.display.brightness(block, sky);
            return true;
        }
        return false;
    }

    public synchronized boolean addRotationModifier(@NotNull Predicate<RenderedBone> predicate, @NotNull Function<Quaternionf, Quaternionf> function) {
        if (predicate.test(this)) {
            this.rotationModifier = this.rotationModifier.andThen(function);
            return true;
        }
        return false;
    }

    public synchronized boolean addPositionModifier(@NotNull Predicate<RenderedBone> predicate, @NotNull Function<Vector3f, Vector3f> function) {
        if (predicate.test(this)) {
            this.positionModifier = this.positionModifier.andThen(function);
            return true;
        }
        return false;
    }

    private boolean keyframeFinished() {
        return this.delay <= 0L;
    }

    private boolean shouldUpdateAnimation() {
        return this.forceUpdateAnimation.compareAndSet(true, false) || this.keyframeFinished() || this.delay % 5L == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateAnimation() {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            Iterator<TreeIterator> iterator2 = this.reversedView.iterator();
            while (iterator2.hasNext()) {
                TreeIterator next = iterator2.next();
                if (!next.getAsBoolean()) continue;
                if (this.currentIterator == null) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    this.currentIterator = next;
                    return true;
                }
                if (this.currentIterator != next) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    this.currentIterator.clear();
                    this.currentIterator = next;
                    this.delay = 0L;
                    return true;
                }
                if (this.keyframeFinished()) {
                    if (!this.updateKeyframe(iterator2, next)) continue;
                    return true;
                }
                return false;
            }
        }
        return this.setKeyframe(null);
    }

    private boolean updateKeyframe(@NotNull Iterator<TreeIterator> iterator2, @NotNull TreeIterator next) {
        if (!next.hasNext()) {
            next.run();
            iterator2.remove();
            return false;
        }
        return this.setKeyframe(next.next());
    }

    private boolean setKeyframe(@Nullable AnimationMovement next) {
        if (this.keyFrame == next) {
            return false;
        }
        this.relativeOffsetCache = null;
        this.keyFrame = next;
        return true;
    }

    public synchronized boolean move(@Nullable ModelRotation rotation, @NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (rotation != null) {
            this.rotation = rotation;
            if (d != null) {
                d.rotate(rotation, bundler);
            }
        }
        --this.delay;
        if (this.firstTick || this.shouldUpdateAnimation() && this.updateAnimation()) {
            this.firstTick = false;
            int f = this.frame();
            this.delay = f;
            this.beforeTransform = this.afterTransform;
            BoneMovement boneMovement = this.afterTransform = this.relativeOffset();
            if (d != null) {
                d.frame(RenderedBone.toInterpolationDuration(f));
                this.setup(boneMovement);
                d.sendTransformation(bundler);
                return true;
            }
        }
        return false;
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null) {
            d.sendEntityData(bundler);
        }
    }

    public void forceUpdate(boolean showItem, @NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null) {
            d.sendEntityData(showItem, bundler);
        }
    }

    private static int toInterpolationDuration(long delay) {
        return (int)Math.ceil((float)delay / 5.0f);
    }

    @NotNull
    public Vector3f worldPosition() {
        return this.worldPosition(EMPTY_VECTOR);
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f localOffset) {
        return this.worldPosition(localOffset, EMPTY_VECTOR);
    }

    @NotNull
    public Vector3f worldPosition(@NotNull Vector3f localOffset, @NotNull Vector3f globalOffset) {
        float progress = 1.0f - this.progress();
        BoneMovement after = this.afterTransform != null ? this.afterTransform : this.relativeOffset();
        BoneMovement before = this.beforeTransform != null ? this.beforeTransform : BoneMovement.EMPTY;
        return VectorUtil.linear(before.transform(), after.transform(), progress).add((Vector3fc)this.itemStack.offset()).add((Vector3fc)localOffset).rotate((Quaternionfc)MathUtil.toQuaternion(VectorUtil.linear(before.rawRotation(), after.rawRotation(), progress))).fma((Vector3fc)VectorUtil.linear(before.scale(), after.scale(), progress), (Vector3fc)globalOffset).add((Vector3fc)this.root.getGroup().getPosition()).mul(this.scale.getAsFloat()).rotateX(-this.rotation.radianX()).rotateY(-this.rotation.radianY());
    }

    @NotNull
    public Quaternionf worldRotation() {
        float progress = 1.0f - this.progress();
        BoneMovement after = this.afterTransform != null ? this.afterTransform : this.relativeOffset();
        BoneMovement before = this.beforeTransform != null ? this.beforeTransform : BoneMovement.EMPTY;
        return new Quaternionf().rotateZYX(0.0f, -this.rotation.radianY(), -this.rotation.radianX()).mul((Quaternionfc)MathUtil.toQuaternion(VectorUtil.linear(before.rawRotation(), after.rawRotation(), progress)));
    }

    private void setup(@NotNull BoneMovement boneMovement) {
        if (this.display != null) {
            float mul = this.scale.getAsFloat();
            this.display.transform(new Vector3f((Vector3fc)boneMovement.transform()).add((Vector3fc)this.root.group.getPosition()).add((Vector3fc)new Vector3f((Vector3fc)this.itemStack.offset()).rotate((Quaternionfc)boneMovement.rotation())).fma(mul, (Vector3fc)this.defaultPosition.get()), new Vector3f((Vector3fc)boneMovement.scale()).mul((Vector3fc)this.itemStack.scale()).mul(mul), boneMovement.rotation());
        }
    }

    public void defaultPosition(@NotNull Supplier<Vector3f> movement) {
        this.defaultPosition = () -> new Vector3f((Vector3fc)movement.get()).add((Vector3fc)this.itemStack.position());
    }

    private int frame() {
        return this.keyFrame != null ? Math.round(this.keyFrame.time() * 100.0f) : (this.parent != null ? this.parent.frame() : 0);
    }

    @NotNull
    private BoneMovement defaultFrame() {
        return this.defaultFrame.plus(this.keyFrame != null ? this.keyFrame : new AnimationMovement(0.0f, null, null, null));
    }

    private float progress() {
        int f = this.frame();
        return f == 0 ? 0.0f : (float)this.delay / (float)f;
    }

    @NotNull
    private BoneMovement relativeOffset() {
        boolean preventModifierUpdate;
        if (this.relativeOffsetCache != null) {
            return this.relativeOffsetCache;
        }
        BoneMovement def = this.defaultFrame();
        boolean bl = preventModifierUpdate = this.frame() < 3;
        if (this.parent != null) {
            BoneMovement p = this.parent.relativeOffset();
            this.relativeOffsetCache = new BoneMovement(def.transform().rotate((Quaternionfc)p.rotation()).fma((Vector3fc)p.scale(), (Vector3fc)p.transform()).sub((Vector3fc)this.parent.lastModifiedPosition).add((Vector3fc)this.modifiedPosition(preventModifierUpdate)), def.scale().mul((Vector3fc)p.scale()), new Quaternionf((Quaternionfc)p.rotation()).div((Quaternionfc)this.parent.lastModifiedRotation).mul((Quaternionfc)def.rotation()).mul((Quaternionfc)this.modifiedRotation(preventModifierUpdate)), def.rawRotation());
            return this.relativeOffsetCache;
        }
        this.relativeOffsetCache = new BoneMovement(def.transform().add((Vector3fc)this.modifiedPosition(preventModifierUpdate)), def.scale(), def.rotation().mul((Quaternionfc)this.modifiedRotation(preventModifierUpdate)), def.rawRotation());
        return this.relativeOffsetCache;
    }

    @NotNull
    private Vector3f modifiedPosition(boolean preventModifierUpdate) {
        return preventModifierUpdate ? this.lastModifiedPosition : (this.lastModifiedPosition = this.positionModifier.apply(new Vector3f()));
    }

    @NotNull
    private Quaternionf modifiedRotation(boolean preventModifierUpdate) {
        return preventModifierUpdate ? this.lastModifiedRotation : (this.lastModifiedRotation = this.rotationModifier.apply(new Quaternionf()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tint(@NotNull Predicate<RenderedBone> predicate, int tint) {
        if (tint == -1) {
            tint = this.previousTint;
        }
        if (this.tint != tint && predicate.test(this)) {
            Object object = this.itemLock;
            synchronized (object) {
                if (this.tint == tint) {
                    return false;
                }
                this.previousTint = this.tint;
                this.tint = tint;
                return this.applyItem();
            }
        }
        return false;
    }

    private boolean applyItem() {
        if (this.display != null) {
            this.display.item(this.itemStack.isAir() ? AIR : (ItemStack)this.tintCacheMap.computeIfAbsent(this.tint, i -> BetterModel.plugin().nms().tint(this.itemStack.itemStack(), i)));
            return true;
        }
        return false;
    }

    @NotNull
    public BoneName getName() {
        return this.getGroup().getName();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.teleport(location, bundler);
        }
    }

    public void spawn(boolean hide, @NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.spawn(!hide && !this.display.invisible(), bundler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAnimation(@NotNull AnimationPredicate filter, @NotNull String parent, @NotNull BlueprintAnimation animator, @NotNull AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            if (get == null && animator.override() && !filter.isChildren()) {
                return false;
            }
            AnimationIterator.Type type = modifier.type(animator.loop());
            TreeIterator iterator2 = get != null ? new TreeIterator(this, parent, get.iterator(type), modifier, removeTask) : new TreeIterator(this, parent, animator.emptyIterator(type), modifier, removeTask);
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.putLast(parent, iterator2);
            }
            this.forceUpdateAnimation.set(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceAnimation(@NotNull AnimationPredicate filter, @NotNull String target, @NotNull String parent, @NotNull BlueprintAnimation animator, @NotNull AnimationModifier modifier) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            if (get == null && animator.override() && !filter.isChildren()) {
                return false;
            }
            AnimationIterator.Type type = modifier.type(animator.loop());
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                TreeIterator v = (TreeIterator)this.animators.get(target);
                if (v != null) {
                    this.animators.replace(target, get != null ? new TreeIterator(this, parent, get.iterator(type), v.modifier, v.removeTask) : new TreeIterator(this, parent, animator.emptyIterator(type), v.modifier, v.removeTask));
                } else {
                    this.animators.replace(target, get != null ? new TreeIterator(this, parent, get.iterator(type), modifier, () -> {}) : new TreeIterator(this, parent, animator.emptyIterator(type), modifier, () -> {}));
                }
            }
            this.forceUpdateAnimation.set(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String parent) {
        if (filter.test(this)) {
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                if (this.animators.remove(parent) != null) {
                    this.forceUpdateAnimation.set(true);
                }
            }
        }
    }

    public void remove(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.remove(bundler);
        }
    }

    public boolean togglePart(@NotNull Predicate<RenderedBone> predicate, boolean toggle) {
        if (this.display != null && predicate.test(this)) {
            this.display.invisible(!toggle);
            return true;
        }
        return false;
    }

    @Nullable
    public RenderedBone boneOf(@NotNull Predicate<RenderedBone> predicate) {
        return this.findNotNullByTree(b -> predicate.test((RenderedBone)b) ? b : null);
    }

    @Nullable
    public <T> T findNotNullByTree(@NotNull Function<RenderedBone, T> mapper) {
        T value = mapper.apply(this);
        if (value != null) {
            return value;
        }
        for (RenderedBone renderedBone : this.children.values()) {
            T childValue = renderedBone.findNotNullByTree(mapper);
            if (childValue == null) continue;
            return childValue;
        }
        return null;
    }

    public void iterateTree(@NotNull Consumer<RenderedBone> boneConsumer) {
        boneConsumer.accept(this);
        for (RenderedBone value : this.children.values()) {
            value.iterateTree(boneConsumer);
        }
    }

    public boolean matchTree(@NotNull Predicate<RenderedBone> bonePredicate) {
        boolean result = bonePredicate.test(this);
        for (RenderedBone value : this.children.values()) {
            if (!value.matchTree(bonePredicate)) continue;
            result = true;
        }
        return result;
    }

    public boolean iterateTree(@NotNull BonePredicate predicate, @NotNull BiPredicate<RenderedBone, BonePredicate> mapper) {
        boolean parentResult = mapper.test(this, predicate);
        BonePredicate childPredicate = predicate.children(parentResult);
        for (RenderedBone value : this.children.values()) {
            if (!value.iterateTree(childPredicate, mapper)) continue;
            parentResult = true;
        }
        return parentResult;
    }

    public boolean iterateAnimation(@NotNull AnimationPredicate predicate, @NotNull BiPredicate<RenderedBone, AnimationPredicate> mapper) {
        boolean parentResult = mapper.test(this, predicate);
        AnimationPredicate childPredicate = predicate;
        if (parentResult) {
            childPredicate = childPredicate.children();
        }
        for (RenderedBone value : this.children.values()) {
            if (!value.iterateAnimation(childPredicate, mapper)) continue;
            parentResult = true;
        }
        return parentResult;
    }

    @Override
    @NotNull
    public Vector3f hitBoxPosition() {
        NamedBoundingBox box = this.getGroup().getHitBox();
        if (box != null) {
            return this.worldPosition(box.centerPoint());
        }
        return this.worldPosition();
    }

    @Override
    @NotNull
    public Quaternionf hitBoxViewRotation() {
        return this.worldRotation();
    }

    @Override
    public float hitBoxScale() {
        return this.scale.getAsFloat();
    }

    @Override
    @NotNull
    public ModelRotation hitBoxRotation() {
        return this.rotation;
    }

    @NotNull
    @Generated
    public RendererGroup getGroup() {
        return this.group;
    }

    @NotNull
    @Generated
    public RenderedBone getRoot() {
        return this.root;
    }

    @Nullable
    @Generated
    public RenderedBone getParent() {
        return this.parent;
    }

    @NotNull
    @Generated
    public Map<BoneName, RenderedBone> getChildren() {
        return this.children;
    }

    @Generated
    public boolean isDummyBone() {
        return this.dummyBone;
    }

    @Nullable
    @Generated
    public ModelDisplay getDisplay() {
        return this.display;
    }

    @Nullable
    @Generated
    public HitBox getHitBox() {
        return this.hitBox;
    }

    @Generated
    public BoneItemMapper getItemMapper() {
        return this.itemMapper;
    }

    @Generated
    public void setItemMapper(BoneItemMapper itemMapper) {
        this.itemMapper = itemMapper;
    }

    private class TreeIterator
    implements AnimationIterator,
    BooleanSupplier,
    Runnable {
        private final RunningAnimation animation;
        private final AnimationIterator iterator;
        private final AnimationModifier modifier;
        private final Runnable removeTask;
        private final AnimationMovement previous;
        private boolean started = false;
        private boolean ended = false;

        public TreeIterator(RenderedBone renderedBone, String name, AnimationIterator iterator2, AnimationModifier modifier, Runnable removeTask) {
            this.animation = new RunningAnimation(name, iterator2.type());
            this.iterator = iterator2;
            this.modifier = modifier;
            this.removeTask = removeTask;
            this.previous = renderedBone.keyFrame != null ? renderedBone.keyFrame.time((float)modifier.end() / 20.0f) : new AnimationMovement((float)modifier.end() / 20.0f, null, null, null);
        }

        @Override
        @NotNull
        public AnimationMovement first() {
            return this.iterator.first();
        }

        @Override
        public int index() {
            return this.iterator.index();
        }

        @Override
        public int lastIndex() {
            return this.iterator.lastIndex();
        }

        @Override
        public void run() {
            this.removeTask.run();
        }

        @Override
        public boolean getAsBoolean() {
            return this.modifier.predicate().getAsBoolean();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() || this.modifier.end() > 0 && !this.ended;
        }

        @Override
        public AnimationMovement next() {
            if (!this.started) {
                this.started = true;
                return this.first().time((float)this.modifier.start() / 20.0f);
            }
            if (!this.iterator.hasNext()) {
                this.ended = true;
                return this.previous;
            }
            AnimationMovement nxt = (AnimationMovement)this.iterator.next();
            nxt = nxt.time(nxt.time() / this.modifier.speedValue());
            return nxt;
        }

        @Override
        public void clear() {
            this.iterator.clear();
            this.ended = !this.iterator.hasNext();
            this.started = this.ended;
        }

        @Override
        @NotNull
        public AnimationIterator.Type type() {
            return this.iterator.type();
        }
    }

    public record RunningAnimation(@NotNull String name, @NotNull AnimationIterator.Type type) {
    }
}

