/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.ModelBlueprint;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.DummyTracker;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ModelRenderer {
    private final ModelBlueprint parent;
    private final Map<BoneName, RendererGroup> rendererGroupMap;
    private final Map<String, BlueprintAnimation> animationMap;

    @Nullable
    public RendererGroup groupByTree(@NotNull BoneName name) {
        return ModelRenderer.groupByTree0(this.rendererGroupMap, name);
    }

    @Nullable
    private static RendererGroup groupByTree0(@NotNull Map<BoneName, RendererGroup> map, @NotNull BoneName name) {
        if (map.isEmpty()) {
            return null;
        }
        RendererGroup get = map.get(name);
        if (get != null) {
            return get;
        }
        return map.values().stream().map(g -> ModelRenderer.groupByTree0(g.getChildren(), name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    public @Unmodifiable Set<String> animations() {
        return Collections.unmodifiableSet(this.animationMap.keySet());
    }

    @NotNull
    public String name() {
        return this.parent.name();
    }

    @NotNull
    public DummyTracker create(@NotNull Location location) {
        return this.create(location, TrackerModifier.DEFAULT);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull TrackerModifier modifier) {
        RenderSource.Located source = RenderSource.of(location);
        return source.create(this.pipeline(source, location, modifier), modifier);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull Player player) {
        return this.create(location, player, TrackerModifier.DEFAULT);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull GameProfile profile) {
        return this.create(location, profile, TrackerModifier.DEFAULT);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull GameProfile profile, boolean slim) {
        return this.create(location, profile, slim, TrackerModifier.DEFAULT);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull Player player, @NotNull TrackerModifier modifier) {
        PlayerChannelHandler channel = BetterModel.plugin().playerManager().player(player.getUniqueId());
        return channel == null ? this.create(location, BetterModel.plugin().nms().profile(player), modifier) : this.create(location, channel.profile(), channel.isSlim(), modifier);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull GameProfile profile, @NotNull TrackerModifier modifier) {
        return this.create(location, profile, BetterModel.plugin().skinManager().isSlim(profile), modifier);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull GameProfile profile, boolean slim, @NotNull TrackerModifier modifier) {
        RenderSource.Located source = RenderSource.of(location, profile, slim);
        return source.create(this.pipeline(source, location, modifier), modifier);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity) {
        return this.create(entity, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity) {
        return this.getOrCreate(entity, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull TrackerModifier modifier) {
        RenderSource.Based source = RenderSource.of(entity);
        return source.create(this.pipeline(source, entity.getLocation().add(0.0, -1024.0, 0.0), modifier), modifier);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull TrackerModifier modifier) {
        RenderSource.Based source = RenderSource.of(entity);
        return source.getOrCreate(this.name(), () -> this.pipeline(source, entity.getLocation().add(0.0, -1024.0, 0.0), modifier), modifier);
    }

    @NotNull
    private RenderPipeline pipeline(@NotNull RenderSource source, @NotNull Location location, @NotNull TrackerModifier modifier) {
        return new RenderPipeline(this, source, this.rendererGroupMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RendererGroup)e.getValue()).create(source, modifier, location))), this.animationMap);
    }

    @Generated
    public ModelRenderer(ModelBlueprint parent, Map<BoneName, RendererGroup> rendererGroupMap, Map<String, BlueprintAnimation> animationMap) {
        this.parent = parent;
        this.rendererGroupMap = rendererGroupMap;
        this.animationMap = animationMap;
    }

    @Generated
    public ModelBlueprint getParent() {
        return this.parent;
    }
}

