/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import kr.toxicity.model.api.tracker.ModelScaler;
import kr.toxicity.model.api.util.EntityUtil;
import org.jetbrains.annotations.NotNull;

public record TrackerModifier(@NotNull ModelScaler scale, @SerializedName(value="sight-trace") boolean sightTrace, @SerializedName(value="damage-animation") boolean damageAnimation, @SerializedName(value="damage-tint") boolean damageTint, @SerializedName(value="view-range") float viewRange, boolean shadow) {
    public static final TrackerModifier DEFAULT = new TrackerModifier(ModelScaler.entity(), true, true, true, EntityUtil.ENTITY_MODEL_VIEW_RADIUS, true);

    @NotNull
    public static Builder builder() {
        return DEFAULT.toBuilder();
    }

    @NotNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private ModelScaler scale;
        private boolean sightTrace;
        private boolean damageAnimation;
        private boolean damageTint;
        private float viewRange;
        private boolean shadow;

        private Builder(@NotNull TrackerModifier modifier) {
            this.scale = modifier.scale;
            this.sightTrace = modifier.sightTrace;
            this.damageAnimation = modifier.damageAnimation;
            this.damageTint = modifier.damageTint;
            this.viewRange = modifier.viewRange;
            this.shadow = modifier.shadow;
        }

        @NotNull
        public Builder scale(@NotNull ModelScaler scale) {
            this.scale = Objects.requireNonNull(scale, "scale cannot be null.");
            return this;
        }

        @NotNull
        public Builder sightTrace(boolean sightTrace) {
            this.sightTrace = sightTrace;
            return this;
        }

        @NotNull
        public Builder damageAnimation(boolean damageAnimation) {
            this.damageAnimation = damageAnimation;
            return this;
        }

        @NotNull
        public Builder damageTint(boolean damageTint) {
            this.damageTint = damageTint;
            return this;
        }

        @NotNull
        public Builder viewRange(float viewRange) {
            this.viewRange = viewRange;
            return this;
        }

        @NotNull
        public Builder shadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        @NotNull
        public TrackerModifier build() {
            return new TrackerModifier(this.scale, this.sightTrace, this.damageAnimation, this.damageTint, this.viewRange, this.shadow);
        }
    }
}

