/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import it.unimi.dsi.fastutil.floats.FloatAVLTreeSet;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatComparators;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationPoint;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.interpolation.VectorInterpolation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class VectorUtil {
    private static final float FRAME_HASH = 0.031f;

    private VectorUtil() {
        throw new RuntimeException();
    }

    private static void point(@NotNull FloatCollection target, List<VectorPoint> points) {
        for (VectorPoint point : points) {
            target.add(point.time());
        }
    }

    @NotNull
    public static List<AnimationPoint> putAnimationPoint(@NotNull List<AnimationPoint> animations, @NotNull FloatCollection points) {
        return VectorUtil.sum(animations.stream().map(AnimationPoint::position).distinct().toList(), animations.stream().map(AnimationPoint::rotation).distinct().toList(), animations.stream().map(AnimationPoint::scale).distinct().toList(), points);
    }

    @NotNull
    public static List<AnimationPoint> sum(float length, @NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation, @NotNull List<VectorPoint> scale) {
        FloatAVLTreeSet set = new FloatAVLTreeSet((Comparator)FloatComparators.NATURAL_COMPARATOR);
        set.add(length);
        VectorUtil.point((FloatCollection)set, position);
        VectorUtil.point((FloatCollection)set, scale);
        VectorUtil.point((FloatCollection)set, rotation);
        VectorUtil.insertRotationFrame((FloatSet)set, rotation);
        VectorUtil.insertLerpFrame((FloatCollection)set);
        return VectorUtil.sum(position, rotation, scale, (FloatCollection)set);
    }

    @NotNull
    public static List<AnimationPoint> sum(@NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation, @NotNull List<VectorPoint> scale, FloatCollection points) {
        ArrayList<AnimationPoint> list = new ArrayList<AnimationPoint>();
        List<VectorPoint> pp = VectorUtil.putPoint(position, points);
        List<VectorPoint> rp = VectorUtil.putPoint(rotation, points);
        List<VectorPoint> sp = VectorUtil.putPoint(scale, points);
        for (int i = 0; i < pp.size(); ++i) {
            list.add(new AnimationPoint(pp.get(i), rp.get(i), sp.get(i)));
        }
        return list;
    }

    @NotNull
    public static List<VectorPoint> putPoint(@NotNull List<VectorPoint> vectors, @NotNull FloatCollection points) {
        ArrayList<VectorPoint> newVectors = new ArrayList<VectorPoint>();
        if (vectors.isEmpty()) {
            points.iterator().forEachRemaining(f -> newVectors.add(new VectorPoint(new Vector3f(), f, VectorInterpolation.defaultInterpolation())));
            return newVectors;
        }
        VectorPoint last = vectors.getLast();
        float length = last.time();
        int i = 0;
        VectorPoint p2 = vectors.getFirst();
        float t = p2.time();
        FloatIterator floatIterator = points.iterator();
        while (floatIterator.hasNext()) {
            float point = ((Float)floatIterator.next()).floatValue();
            while (i < vectors.size() - 1 && t < point) {
                p2 = vectors.get(++i);
                t = p2.time();
            }
            if (point > length) {
                newVectors.add(new VectorPoint(last.vector(), point, last.interpolation()));
                continue;
            }
            newVectors.add(point == t ? vectors.get(i) : p2.interpolation().interpolate(vectors, i, point));
        }
        if (t < length) {
            newVectors.addAll(vectors.subList(i, vectors.size()));
        }
        return newVectors;
    }

    public static void insertRotationFrame(@NotNull FloatSet frames, @NotNull List<VectorPoint> vectorPoints) {
        for (int i = 0; i < vectorPoints.size() - 1; ++i) {
            VectorPoint before = vectorPoints.get(i);
            VectorPoint after = vectorPoints.get(i + 1);
            float angle = (float)Math.ceil(Math.toDegrees(MathUtil.toQuaternion(after.vector()).mul((Quaternionfc)MathUtil.toQuaternion(before.vector()).invert()).angle()) / 45.0);
            if (!(angle > 1.0f)) continue;
            for (float t = 1.0f; t < angle; t += 1.0f) {
                frames.add(VectorUtil.linear(before.time(), after.time(), t / angle));
            }
        }
    }

    public static void insertLerpFrame(@NotNull FloatCollection frames) {
        VectorUtil.insertLerpFrame(frames, (float)BetterModel.plugin().configManager().lerpFrameTime() / 20.0f);
    }

    public static void insertLerpFrame(@NotNull FloatCollection frames, float frame) {
        if (frame <= 0.0f) {
            return;
        }
        frame += 0.031f;
        FloatArrayList list = new FloatArrayList(frames);
        float init = 0.0f;
        Float initAfter = (Float)list.getFirst();
        while (true) {
            float f;
            init += frame;
            if (!(f < initAfter.floatValue() - frame)) break;
            frames.add(init);
        }
        block1: for (int i = 0; i < list.size() - 1; ++i) {
            float before = list.getFloat(i);
            float after = list.getFloat(i + 1);
            while (true) {
                float f;
                before += frame;
                if (!(f < after - frame)) continue block1;
                frames.add(before);
            }
        }
    }

    public static float alpha(float p0, float p1, float alpha) {
        float div = p1 - p0;
        return div == 0.0f ? 0.0f : (alpha - p0) / div;
    }

    @NotNull
    public static Vector3f linear(@NotNull Vector3f p0, @NotNull Vector3f p1, float alpha) {
        return new Vector3f(VectorUtil.linear(p0.x, p1.x, alpha), VectorUtil.linear(p0.y, p1.y, alpha), VectorUtil.linear(p0.z, p1.z, alpha));
    }

    public static float linear(float p0, float p1, float alpha) {
        return Math.fma(p1 - p0, alpha, p0);
    }

    public static float cubicBezier(float p0, float p1, float p2, float p3, float t) {
        float u = 1.0f - t;
        float uu = u * u;
        float tt = t * t;
        float uuu = uu * u;
        float utt = u * tt;
        float uut = uu * t;
        float ttt = tt * t;
        return Math.fma(uuu, p0, Math.fma(3.0f * uut, p1, Math.fma(3.0f * utt, p2, ttt * p3)));
    }

    public static float derivativeBezier(float p0, float p1, float p2, float p3, float t) {
        float u = 1.0f - t;
        float uu = u * u;
        float ut = u * t;
        float tt = t * t;
        return Math.fma(3.0f * uu, p1 - p0, Math.fma(6.0f * ut, p2 - p1, 3.0f * tt * (p3 - p2)));
    }

    public static float solveBezierTForTime(float time, float t0, float h1, float h2, float t1) {
        float t = 0.5f;
        int maxIterations = 20;
        float epsilon = 1.0E-5f;
        for (int i = 0; i < maxIterations; ++i) {
            float bezTime = VectorUtil.cubicBezier(t0, h1, h2, t1, t);
            float derivative = VectorUtil.derivativeBezier(t0, h1, h2, t1, t);
            float error = bezTime - time;
            if (Math.abs(error) < epsilon) {
                return t;
            }
            if (derivative != 0.0f) {
                t -= error / derivative;
            }
            t = Math.max(0.0f, Math.min(1.0f, t));
        }
        return t;
    }

    @NotNull
    public static Vector3f bezier(float time, float startTime, float endTime, @NotNull Vector3f startValue, @NotNull Vector3f endValue, @Nullable Vector3f bezierLeftTime, @Nullable Vector3f bezierLeftValue, @Nullable Vector3f bezierRightTime, @Nullable Vector3f bezierRightValue) {
        Vector3f p1 = bezierRightValue != null ? new Vector3f((Vector3fc)bezierRightValue).add((Vector3fc)startValue) : startValue;
        Vector3f p2 = bezierLeftValue != null ? new Vector3f((Vector3fc)bezierLeftValue).add((Vector3fc)endValue) : endValue;
        return new Vector3f(VectorUtil.cubicBezier(startValue.x, p1.x, p2.x, endValue.x, VectorUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.x + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.x + endTime : endTime, endTime)), VectorUtil.cubicBezier(startValue.y, p1.y, p2.y, endValue.y, VectorUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.y + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.y + endTime : endTime, endTime)), VectorUtil.cubicBezier(startValue.z, p1.z, p2.z, endValue.z, VectorUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.z + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.z + endTime : endTime, endTime)));
    }

    @NotNull
    public static Vector3f catmull_rom(@NotNull Vector3f p0, @NotNull Vector3f p1, @NotNull Vector3f p2, @NotNull Vector3f p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return new Vector3f(Math.fma(t3, Math.fma(-1.0f, p0.x, Math.fma(3.0f, p1.x, Math.fma(-3.0f, p2.x, p3.x))), Math.fma(t2, Math.fma(2.0f, p0.x, Math.fma(-5.0f, p1.x, Math.fma(4.0f, p2.x, -p3.x))), Math.fma(t, -p0.x + p2.x, 2.0f * p1.x))), Math.fma(t3, Math.fma(-1.0f, p0.y, Math.fma(3.0f, p1.y, Math.fma(-3.0f, p2.y, p3.y))), Math.fma(t2, Math.fma(2.0f, p0.y, Math.fma(-5.0f, p1.y, Math.fma(4.0f, p2.y, -p3.y))), Math.fma(t, -p0.y + p2.y, 2.0f * p1.y))), Math.fma(t3, Math.fma(-1.0f, p0.z, Math.fma(3.0f, p1.z, Math.fma(-3.0f, p2.z, p3.z))), Math.fma(t2, Math.fma(2.0f, p0.z, Math.fma(-5.0f, p1.z, Math.fma(4.0f, p2.z, -p3.z))), Math.fma(t, -p0.z + p2.z, 2.0f * p1.z)))).mul(0.5f);
    }
}

