/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import kr.toxicity.model.api.animation.Timed;
import kr.toxicity.model.api.data.raw.Datapoint;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.KeyframeChannel;
import kr.toxicity.model.api.util.interpolator.BezierInterpolator;
import kr.toxicity.model.api.util.interpolator.CatmullRomInterpolator;
import kr.toxicity.model.api.util.interpolator.LinearInterpolator;
import kr.toxicity.model.api.util.interpolator.StepInterpolator;
import kr.toxicity.model.api.util.interpolator.VectorInterpolator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModelKeyframe(@Nullable KeyframeChannel channel, @SerializedName(value="data_points") @NotNull List<Datapoint> dataPoints, @SerializedName(value="bezier_left_time") @Nullable Float3 bezierLeftTime, @SerializedName(value="bezier_left_value") @Nullable Float3 bezierLeftValue, @SerializedName(value="bezier_right_time") @Nullable Float3 bezierRightTime, @SerializedName(value="bezier_right_value") @Nullable Float3 bezierRightValue, @Nullable String interpolation, float time) implements Timed
{
    @Nullable
    private final KeyframeChannel channel;

    public boolean hasPoint() {
        return !this.dataPoints.isEmpty();
    }

    @NotNull
    public Datapoint point() {
        return this.dataPoints.getFirst();
    }

    @NotNull
    public VectorInterpolator findInterpolator() {
        if (this.interpolation == null) {
            return VectorInterpolator.defaultInterpolator();
        }
        return switch (this.interpolation.toLowerCase(Locale.ROOT)) {
            case "linear" -> LinearInterpolator.INSTANCE;
            case "catmullrom" -> CatmullRomInterpolator.INSTANCE;
            case "step" -> StepInterpolator.INSTANCE;
            case "bezier" -> new BezierInterpolator(Optional.ofNullable(this.bezierLeftTime).map(Float3::toVector).orElse(null), Optional.ofNullable(this.bezierLeftValue).map(Float3::toVector).orElse(null), Optional.ofNullable(this.bezierRightTime).map(Float3::toVector).orElse(null), Optional.ofNullable(this.bezierRightValue).map(Float3::toVector).orElse(null));
            default -> VectorInterpolator.defaultInterpolator();
        };
    }

    @NotNull
    public KeyframeChannel channel() {
        return this.channel != null ? this.channel : KeyframeChannel.NOT_FOUND;
    }
}

