/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.raw.ModelPlaceholder;
import kr.toxicity.model.api.util.function.Float2FloatConstantFunction;
import kr.toxicity.model.api.util.function.Float2FloatFunction;
import kr.toxicity.model.api.util.function.FloatFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Internal
public record Datapoint(@Nullable JsonPrimitive x, @Nullable JsonPrimitive y, @Nullable JsonPrimitive z, @Nullable String script) {
    @Nullable
    private final String script;
    public static final JsonDeserializer<Datapoint> PARSER = (json, typeOfT, context) -> {
        JsonObject object = json.getAsJsonObject();
        JsonPrimitive script = object.getAsJsonPrimitive("script");
        return new Datapoint(object.getAsJsonPrimitive("x"), object.getAsJsonPrimitive("y"), object.getAsJsonPrimitive("z"), script != null ? script.getAsString() : null);
    };

    public boolean hasScript() {
        return this.script != null;
    }

    @NotNull
    public String script() {
        return Objects.requireNonNull(this.script);
    }

    @NotNull
    private static Float2FloatFunction build(@Nullable JsonPrimitive primitive, @NotNull ModelPlaceholder placeholder) {
        if (primitive == null) {
            return Float2FloatFunction.ZERO;
        }
        if (primitive.isNumber()) {
            return Float2FloatFunction.of(primitive.getAsFloat());
        }
        String string = primitive.getAsString().trim();
        if (string.isEmpty()) {
            return Float2FloatFunction.ZERO;
        }
        try {
            return Float2FloatFunction.of(Float.parseFloat(string));
        }
        catch (NumberFormatException ignored) {
            return BetterModel.plugin().evaluator().compile(placeholder.parseVariable(string));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public FloatFunction<Vector3f> toFunction(@NotNull ModelPlaceholder placeholder) {
        float xc;
        float f2;
        Float2FloatFunction xb = Datapoint.build(this.x, placeholder);
        Float2FloatFunction yb = Datapoint.build(this.y, placeholder);
        Float2FloatFunction zb = Datapoint.build(this.z, placeholder);
        if (!(xb instanceof Float2FloatConstantFunction)) return f -> new Vector3f(xb.applyAsFloat(f), yb.applyAsFloat(f), zb.applyAsFloat(f));
        Float2FloatConstantFunction float2FloatConstantFunction = (Float2FloatConstantFunction)xb;
        try {
            xc = f2 = float2FloatConstantFunction.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(yb instanceof Float2FloatConstantFunction)) return f -> new Vector3f(xb.applyAsFloat(f), yb.applyAsFloat(f), zb.applyAsFloat(f));
        Float2FloatConstantFunction float2FloatConstantFunction2 = (Float2FloatConstantFunction)yb;
        float yc = f2 = float2FloatConstantFunction2.value();
        if (!(zb instanceof Float2FloatConstantFunction)) return f -> new Vector3f(xb.applyAsFloat(f), yb.applyAsFloat(f), zb.applyAsFloat(f));
        Float2FloatConstantFunction float2FloatConstantFunction3 = (Float2FloatConstantFunction)zb;
        float zc = f2 = float2FloatConstantFunction3.value();
        return FloatFunction.of(new Vector3f(xc, yc, zc));
    }
}

