/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.manager;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface ModelManager {
    @Nullable
    public ModelRenderer model(@NotNull String var1);

    @Deprecated
    @Nullable
    default public ModelRenderer renderer(@NotNull String name) {
        return this.model(name);
    }

    @NotNull
    public @Unmodifiable Collection<ModelRenderer> models();

    @NotNull
    public @Unmodifiable Set<String> modelKeys();

    @NotNull
    public @Unmodifiable Collection<ModelRenderer> limbs();

    @Nullable
    public ModelRenderer limb(@NotNull String var1);

    @NotNull
    public @Unmodifiable Set<String> limbKeys();

    default public boolean animate(@NotNull Player player, @NotNull String model, @NotNull String animation) {
        return this.animate(player, model, animation, AnimationModifier.DEFAULT_WITH_PLAY_ONCE);
    }

    default public boolean animate(@NotNull Player player, @NotNull String model, @NotNull String animation, @NotNull AnimationModifier modifier) {
        return this.animate(player, model, animation, modifier, t -> {});
    }

    default public boolean animate(@NotNull Player player, @NotNull String model, @NotNull String animation, @NotNull AnimationModifier modifier, @NotNull Consumer<EntityTracker> consumer) {
        ModelRenderer get = this.limb(model);
        if (get == null) {
            return false;
        }
        EntityTracker create2 = get.getOrCreate((Entity)player, TrackerModifier.DEFAULT, consumer);
        if (!create2.animate(animation, modifier, create2::close)) {
            create2.close();
            return false;
        }
        return true;
    }
}

