/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import kr.toxicity.model.api.data.raw.Float3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@ApiStatus.Internal
public final class MathUtil {
    public static final int MINECRAFT_TICK_MILLS = 50;
    public static final float ROTATION_DEGREE = 22.5f;
    public static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
    public static final float RADIANS_TO_DEGREES = 57.29578f;
    public static final float DEGREES_TO_PACKED_BYTE = 0.7111111f;
    public static final float MODEL_TO_BLOCK_MULTIPLIER = 16.0f;
    public static final float FRAME_EPSILON = 0.001f;
    public static final float FLOAT_COMPARISON_EPSILON = 1.0E-5f;
    public static final FloatComparator FRAME_COMPARATOR = (a2, b) -> MathUtil.isSimilar(a2, b, 0.001f) ? 0 : Float.compare(a2, b);
    private static final FloatSet VALID_ROTATION_DEGREES = FloatSet.of((float[])new float[]{0.0f, 22.5f, 45.0f, -22.5f, -45.0f});

    private MathUtil() {
        throw new RuntimeException();
    }

    public static boolean isSimilar(float a2, float b) {
        return MathUtil.isSimilar(a2, b, 1.0E-5f);
    }

    public static boolean isSimilar(float a2, float b, float epsilon) {
        return Math.abs(a2 - b) < epsilon;
    }

    public static boolean isSimilar(@NotNull Vector3f a2, @NotNull Vector3f b) {
        return MathUtil.isSimilar(a2, b, 1.0E-5f);
    }

    public static boolean isSimilar(@NotNull Vector3f a2, @NotNull Vector3f b, float epsilon) {
        return MathUtil.isSimilar(a2.x, b.x, epsilon) && MathUtil.isSimilar(a2.y, b.y, epsilon) && MathUtil.isSimilar(a2.z, b.z, epsilon);
    }

    public static boolean isSimilar(@NotNull Quaternionf a2, @NotNull Quaternionf b) {
        return MathUtil.isSimilar(a2, b, 1.0E-5f);
    }

    public static boolean isSimilar(@NotNull Quaternionf a2, @NotNull Quaternionf b, float epsilon) {
        return MathUtil.isSimilar(a2.x, b.x, epsilon) && MathUtil.isSimilar(a2.y, b.y, epsilon) && MathUtil.isSimilar(a2.z, b.z, epsilon) && MathUtil.isSimilar(a2.w, b.w, epsilon);
    }

    public static int similarHashCode(float value) {
        return (int)(value / 1.0E-5f);
    }

    public static boolean checkValidDegree(@NotNull Float3 rotation2) {
        int i = 0;
        if (rotation2.x() != 0.0f) {
            ++i;
        }
        if (rotation2.y() != 0.0f) {
            ++i;
        }
        if (rotation2.z() != 0.0f) {
            ++i;
        }
        return i < 2 && MathUtil.checkValidDegree(rotation2.x()) && MathUtil.checkValidDegree(rotation2.y()) && MathUtil.checkValidDegree(rotation2.z());
    }

    public static boolean checkValidDegree(float rotation2) {
        return VALID_ROTATION_DEGREES.contains(rotation2);
    }

    @NotNull
    public static Float3 identifier(@NotNull Float3 rotation2) {
        if (MathUtil.checkValidDegree(rotation2)) {
            return Float3.ZERO;
        }
        return rotation2;
    }

    @NotNull
    public static Quaternionf toQuaternion(@NotNull Vector3f vector) {
        return new Quaternionf().rotateZYX(vector.z * ((float)Math.PI / 180), vector.y * ((float)Math.PI / 180), vector.x * ((float)Math.PI / 180));
    }

    @NotNull
    public static Vector3f toXYZEuler(@NotNull Vector3f vec) {
        return MathUtil.toXYZEuler(MathUtil.toQuaternion(vec));
    }

    @NotNull
    public static Matrix3f toMatrix(@NotNull Quaternionf quaternion) {
        return quaternion.get(new Matrix3f());
    }

    @NotNull
    public static Vector3f toXYZEuler(@NotNull Quaternionf quaternion) {
        return MathUtil.toXYZEuler(MathUtil.toMatrix(quaternion));
    }

    @NotNull
    public static Vector3f toXYZEuler(@NotNull Matrix3f mat) {
        Vector3f ret = new Vector3f();
        if (Math.abs(mat.m20) < 1.0f) {
            ret.x = (float)Math.atan2(-mat.m21, mat.m22);
            ret.z = (float)Math.atan2(-mat.m10, mat.m00);
        } else {
            ret.x = (float)Math.atan2(mat.m12, mat.m11);
            ret.z = 0.0f;
        }
        ret.y = (float)Math.asin(Math.clamp(mat.m20, -1.0f, 1.0f));
        return ret.mul(57.29578f);
    }

    @NotNull
    public static Vector3f fma(@NotNull Vector3f a2, @NotNull Vector3f b, @NotNull Vector3f c2) {
        a2.x = MathUtil.fma(a2.x, b.x, c2.x);
        a2.y = MathUtil.fma(a2.y, b.y, c2.y);
        a2.z = MathUtil.fma(a2.z, b.z, c2.z);
        return a2;
    }

    @NotNull
    public static Vector3f fma(@NotNull Vector3f a2, float b, @NotNull Vector3f c2) {
        a2.x = MathUtil.fma(a2.x, b, c2.x);
        a2.y = MathUtil.fma(a2.y, b, c2.y);
        a2.z = MathUtil.fma(a2.z, b, c2.z);
        return a2;
    }

    public static float fma(float a2, float b, float c2) {
        return org.joml.Math.fma((float)a2, (float)b, (float)c2);
    }

    public static double fma(double a2, double b, double c2) {
        return org.joml.Math.fma((double)a2, (double)b, (double)c2);
    }

    public static boolean isNotZero(@NotNull Vector3f vector3f) {
        return !MathUtil.isZero(vector3f);
    }

    public static boolean isZero(@NotNull Vector3f vector3f) {
        return MathUtil.isSimilar(vector3f.x, 0.0f) && MathUtil.isSimilar(vector3f.y, 0.0f) && MathUtil.isSimilar(vector3f.z, 0.0f);
    }
}

