/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JsonObjectBuilder {
    private final JsonObject object = new JsonObject();

    private JsonObjectBuilder() {
    }

    @NotNull
    public static JsonObjectBuilder builder() {
        return new JsonObjectBuilder();
    }

    @NotNull
    public JsonObject build() {
        return this.object;
    }

    @NotNull
    public JsonObjectBuilder jsonObject(@NotNull String name, @NotNull Consumer<JsonObjectBuilder> consumer) {
        JsonObjectBuilder builder = JsonObjectBuilder.builder();
        Objects.requireNonNull(consumer).accept(builder);
        if (builder.object.isEmpty()) {
            return this;
        }
        this.object.add(name, (JsonElement)builder.build());
        return this;
    }

    @NotNull
    public JsonObjectBuilder jsonObject(@NotNull String name, @Nullable JsonObject jsonObject) {
        if (jsonObject != null) {
            this.object.add(name, (JsonElement)jsonObject);
        }
        return this;
    }

    @NotNull
    public JsonObjectBuilder jsonArray(@NotNull String name, @Nullable JsonArray array) {
        if (array != null) {
            this.object.add(name, (JsonElement)array);
        }
        return this;
    }

    @NotNull
    public JsonObjectBuilder property(@NotNull String name, @NotNull String property) {
        this.object.addProperty(name, property);
        return this;
    }

    @NotNull
    public JsonObjectBuilder property(@NotNull String name, @NotNull Boolean property) {
        this.object.addProperty(name, property);
        return this;
    }

    @NotNull
    public JsonObjectBuilder property(@NotNull String name, @NotNull Number property) {
        this.object.addProperty(name, property);
        return this;
    }
}

