/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.datagen.provider;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrbysco.weightedinventory.datagen.provider.ArmorSlotBuilder;
import com.mrbysco.weightedinventory.datagen.provider.WrappedSlot;
import com.mrbysco.weightedinventory.registry.ArmorSlot;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public abstract class ArmorSlotProvider
implements DataProvider {
    protected final CompletableFuture<HolderLookup.Provider> lookupProvider;
    protected final PackOutput.PathProvider armorSlotPathProvider;
    private final String modID;

    public ArmorSlotProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modID) {
        this.armorSlotPathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "armor_slot");
        this.lookupProvider = lookupProvider;
        this.modID = modID;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        return this.lookupProvider.thenCompose(registries -> {
            ArrayList list = new ArrayList();
            HashSet set = Sets.newHashSet();
            RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registries);
            this.defineSlots(wrappedSlot -> {
                if (!set.add(wrappedSlot.getId())) {
                    throw new IllegalStateException("Duplicate Places " + String.valueOf(wrappedSlot.getId()));
                }
                list.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)ArmorSlot.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)wrappedSlot.getSlot()).getOrThrow(false, arg_0 -> ((Logger)f_252483_).error(arg_0))), (Path)this.armorSlotPathProvider.m_245731_(wrappedSlot.getId())));
            });
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    public void defineSlots(Consumer<WrappedSlot> consumer) {
    }

    protected void addSlot(Consumer<WrappedSlot> consumer, String name, ArmorSlotBuilder builder) {
        consumer.accept(new WrappedSlot(builder.createArmorSlot(), new ResourceLocation(this.modID, name)));
    }

    public String m_6055_() {
        return "Armor Slots: " + this.modID;
    }
}

