/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.network.packet;

import com.mrbysco.weightedinventory.registry.ArmorSlot;
import com.mrbysco.weightedinventory.registry.ArmorSlotRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class UpdateSlotReferences {
    private final Map<ResourceLocation, ArmorSlot> slotMap;

    public UpdateSlotReferences(Map<ResourceLocation, ArmorSlot> slotMap) {
        this.slotMap = new HashMap<ResourceLocation, ArmorSlot>(slotMap);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_236831_(this.slotMap, FriendlyByteBuf::m_130085_, (byteBuf, slot) -> slot.serializeToNetwork((FriendlyByteBuf)byteBuf));
    }

    public static UpdateSlotReferences decode(FriendlyByteBuf buffer) {
        Map slotMap = buffer.m_236847_(FriendlyByteBuf::m_130281_, ArmorSlot::fromNetwork);
        return new UpdateSlotReferences(slotMap);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                UpdateReferences.update(this.slotMap).run();
            }
        });
        ctx.setPacketHandled(true);
    }

    private static class UpdateReferences {
        private UpdateReferences() {
        }

        private static DistExecutor.SafeRunnable update(final Map<ResourceLocation, ArmorSlot> slotMap) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    ArmorSlotRegistry.updateMap(slotMap);
                }
            };
        }
    }
}

