/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.registry;

import com.mrbysco.weightedinventory.config.WeightedConfig;
import com.mrbysco.weightedinventory.registry.ArmorSlot;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DataPackRegistryEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ArmorSlotRegistry {
    private static final Map<Item, Float> itemSlotCache = new HashMap<Item, Float>();
    private static final Map<ResourceLocation, ArmorSlot> armorSlotMap = new HashMap<ResourceLocation, ArmorSlot>();

    public static float getSlots(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0.0f;
        }
        if (itemSlotCache.containsKey(stack.m_41720_())) {
            return itemSlotCache.get(stack.m_41720_()).floatValue();
        }
        for (ArmorSlot armorSlot : armorSlotMap.values()) {
            for (Holder.Reference<Item> armorItem : armorSlot.armorItems()) {
                if (!stack.m_41720_().m_204114_().equals(armorItem)) continue;
                float slots = armorSlot.slotsPerPiece();
                itemSlotCache.put(stack.m_41720_(), Float.valueOf(slots));
                return slots;
            }
        }
        return ((Double)WeightedConfig.COMMON.defaultSlotCount.get()).floatValue();
    }

    @SubscribeEvent
    public static void onNewRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(ArmorSlot.REGISTRY_KEY, ArmorSlot.DIRECT_CODEC, ArmorSlot.DIRECT_CODEC);
    }

    public static void updateMap(Map<ResourceLocation, ArmorSlot> newMap) {
        armorSlotMap.clear();
        itemSlotCache.clear();
        armorSlotMap.putAll(newMap);
    }
}

