/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.client;

import com.mrbysco.weightedinventory.registry.ArmorSlotRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber
public class TooltipHandler {
    @SubscribeEvent
    public static void onTooltipEvent(ItemTooltipEvent event) {
        float slots;
        ItemStack stack = event.getItemStack();
        EquipmentSlot slot = TooltipHandler.getEquipmentSlotForItem(stack);
        if (slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND && slot != EquipmentSlot.BODY && (slots = ArmorSlotRegistry.getSlots(stack)) > 0.0f) {
            event.getToolTip().add(Component.translatable((String)"weightedinventory.tooltip.slot_count", (Object[])new Object[]{Float.valueOf(slots)}).withStyle(ChatFormatting.BLUE));
        }
    }

    private static EquipmentSlot getEquipmentSlotForItem(ItemStack stack) {
        EquipmentSlot slot = stack.getEquipmentSlot();
        if (slot != null) {
            return slot;
        }
        Equipable equipable = Equipable.get((ItemStack)stack);
        if (equipable != null) {
            return equipable.getEquipmentSlot();
        }
        return EquipmentSlot.MAINHAND;
    }
}

