/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.datagen.provider;

import com.google.common.collect.ImmutableList;
import com.mrbysco.weightedinventory.datagen.provider.ArmorSlotBuilder;
import com.mrbysco.weightedinventory.registry.ArmorSlot;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;

public abstract class ArmorSlotProvider
implements DataProvider {
    protected final CompletableFuture<HolderLookup.Provider> registries;
    protected final PackOutput.PathProvider armorSlotPathProvider;
    private final String modID;
    private final Map<String, WithConditions<ArmorSlot>> toSerialize = new HashMap<String, WithConditions<ArmorSlot>>();

    public ArmorSlotProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, String modID) {
        this.armorSlotPathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "armor_slot");
        this.registries = registries;
        this.modID = modID;
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(registries -> this.run(cache, (HolderLookup.Provider)registries));
    }

    public CompletableFuture<?> run(CachedOutput cache, HolderLookup.Provider registries) {
        this.defineSlots(registries);
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        for (Map.Entry<String, WithConditions<ArmorSlot>> entry : this.toSerialize.entrySet()) {
            String name = entry.getKey();
            WithConditions<ArmorSlot> modifier = entry.getValue();
            Path modifierPath = this.armorSlotPathProvider.json(ResourceLocation.fromNamespaceAndPath((String)this.modID, (String)name));
            futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)registries, ArmorSlot.CONDITIONAL_CODEC, Optional.of(modifier), (Path)modifierPath));
        }
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    public void defineSlots(HolderLookup.Provider registries) {
    }

    public void addSlot(String slotId, ArmorSlotBuilder builder, List<ICondition> conditions) {
        this.toSerialize.put(slotId, (WithConditions<ArmorSlot>)new WithConditions(conditions, (Object)builder.createArmorSlot()));
    }

    public void addSlot(String slotId, ArmorSlotBuilder builder, ICondition ... conditions) {
        this.addSlot(slotId, builder, Arrays.asList(conditions));
    }

    public String getName() {
        return "Armor Slot Definitions: " + this.modID;
    }
}

