/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.menu.slot;

import com.mojang.datafixers.util.Pair;
import com.mrbysco.weightedinventory.WeightedInventoryMod;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WeightedSlot
extends Slot {
    private boolean isUnlocked = false;

    public WeightedSlot(Container container, int slot, int x, int y) {
        super(container, slot, x, y);
    }

    public void setUnlocked(boolean unlocked) {
        this.isUnlocked = unlocked;
    }

    public boolean mayPlace(ItemStack stack) {
        return super.mayPlace(stack) && this.isUnlocked;
    }

    public boolean mayPickup(Player player) {
        return super.mayPickup(player) && this.isUnlocked;
    }

    public boolean allowModification(Player player) {
        return this.isUnlocked;
    }

    public boolean isHighlightable() {
        return this.isUnlocked;
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        if (this.isUnlocked) {
            return null;
        }
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)WeightedInventoryMod.modLoc("item/locked_slot"));
    }
}

