/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.util;

import com.mrbysco.weightedinventory.config.WeightedConfig;
import com.mrbysco.weightedinventory.registry.ArmorSlotRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class UnlockHelper {
    public static boolean isUnlocked(int index, int unlockedSlots) {
        if (unlockedSlots > 0) {
            return index - 9 < unlockedSlots;
        }
        return false;
    }

    public static int getUnlockedSlots(Player player) {
        if (WeightedConfig.COMMON.disableInCreative.getAsBoolean() && player.isCreative()) {
            return 27;
        }
        float slots = 0.0f;
        for (ItemStack armorStack : player.getArmorSlots()) {
            if (armorStack.isEmpty()) continue;
            slots += ArmorSlotRegistry.getSlots(armorStack);
        }
        return Mth.clamp((int)Mth.floor((float)slots), (int)0, (int)27);
    }

    public static int getUnlockedFreeSlot(Player player, NonNullList<ItemStack> items) {
        int unlockedCount = UnlockHelper.getUnlockedSlots(player) + 9;
        int slots = Mth.clamp((int)unlockedCount, (int)0, (int)items.size());
        if (slots == 0) {
            return -1;
        }
        for (int i = 0; i < slots; ++i) {
            if (!((ItemStack)items.get(i)).isEmpty()) continue;
            return i;
        }
        return -1;
    }
}

