/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.handler;

import com.google.common.collect.Multimap;
import com.mrbysco.weightedinventory.registry.ArmorAttributeRegistry;
import com.mrbysco.weightedinventory.registry.ArmorSlotRegistry;
import com.mrbysco.weightedinventory.util.UnlockHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;

public class AttributeHandler {
    public static void addEntityAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)ArmorAttributeRegistry.UNLOCKED.get(), 0.0);
    }

    public static void addItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack armorStack = event.getItemStack();
        EquipmentSlot slot = UnlockHelper.getEquipmentSlotForItem(armorStack);
        Multimap originalModifiers = event.getOriginalModifiers();
        if (originalModifiers.containsKey(ArmorAttributeRegistry.UNLOCKED.get())) {
            return;
        }
        if (slot != null && slot == event.getSlotType() && slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND) {
            float slots = ArmorSlotRegistry.getSlots(armorStack);
            event.addModifier((Attribute)ArmorAttributeRegistry.UNLOCKED.get(), UnlockHelper.createModifier(slot, slots));
        }
    }
}

