/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class ArmorSlot {
    public static final ResourceKey<Registry<ArmorSlot>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("weightedinventory", "armor_slot"));
    public static final Codec<ArmorSlot> DIRECT_CODEC = ExtraCodecs.m_216185_((Codec)RecordCodecBuilder.create(apply -> apply.group((App)ResourceLocation.f_135803_.listOf().fieldOf("armorItems").forGetter(ArmorSlot::armorIds), (App)Codec.FLOAT.fieldOf("slotsPerPiece").forGetter(ArmorSlot::slotsPerPiece)).apply((Applicative)apply, ArmorSlot::new)));
    private final List<ResourceLocation> armorIds;
    private final List<Holder.Reference<Item>> armorItems;
    private final float slotsPerPiece;

    public ArmorSlot(List<ResourceLocation> armorIds, List<Holder.Reference<Item>> armorItems, float slotsPerPiece) {
        this.armorIds = armorIds;
        this.armorItems = armorItems;
        this.slotsPerPiece = slotsPerPiece;
    }

    public ArmorSlot(List<ResourceLocation> armorIds, float slotsPerPiece) {
        this(armorIds, armorIds.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).filter(Objects::nonNull).map(Item::m_204114_).toList(), slotsPerPiece);
    }

    public static ArmorSlot createSlot(List<Holder.Reference<Item>> armorItems, float slotsPerPiece) {
        return new ArmorSlot(armorItems.stream().map(test -> test.m_205785_().m_135782_()).toList(), slotsPerPiece);
    }

    public List<ResourceLocation> armorIds() {
        return this.armorIds;
    }

    public List<Holder.Reference<Item>> armorItems() {
        return this.armorItems;
    }

    public float slotsPerPiece() {
        return this.slotsPerPiece;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ArmorSlot that = (ArmorSlot)obj;
        return Objects.equals(this.armorIds, that.armorIds) && Float.floatToIntBits(this.slotsPerPiece) == Float.floatToIntBits(that.slotsPerPiece);
    }

    public int hashCode() {
        return Objects.hash(this.armorIds, Float.valueOf(this.slotsPerPiece));
    }

    public String toString() {
        return "ArmorSlot[armorItems=" + String.valueOf(this.armorIds) + ", slotsPerPiece=" + this.slotsPerPiece + "]";
    }

    public void serializeToNetwork(FriendlyByteBuf byteBuf) {
        byteBuf.m_236828_(this.armorIds, FriendlyByteBuf::m_130085_);
        byteBuf.writeFloat(this.slotsPerPiece);
    }

    public static ArmorSlot fromNetwork(FriendlyByteBuf byteBuf) {
        List armorIds = byteBuf.m_236845_(FriendlyByteBuf::m_130281_);
        float slotsPerPiece = byteBuf.readFloat();
        return new ArmorSlot(armorIds, slotsPerPiece);
    }
}

