/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.registry;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrbysco.weightedinventory.network.PacketHandler;
import com.mrbysco.weightedinventory.network.packet.UpdateSlotReferences;
import com.mrbysco.weightedinventory.registry.ArmorSlot;
import com.mrbysco.weightedinventory.registry.ArmorSlotRegistry;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="weightedinventory", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArmorSlotReloadListener
extends SimpleJsonResourceReloadListener {
    public static final String FOLDER_NAME = "armor_slot";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ArmorSlotReloadListener INSTANCE = new ArmorSlotReloadListener();
    private Map<ResourceLocation, ArmorSlot> byName = ImmutableMap.of();

    public ArmorSlotReloadListener() {
        super(GSON, FOLDER_NAME);
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ArmorSlot.DIRECT_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(message -> LOGGER.error("Couldn't parse armor slot definition {}: {}", entry.getKey(), message)).ifPresent(test -> mapBuilder.put((Object)((ResourceLocation)entry.getKey()), test));
        }
        this.byName = mapBuilder.build();
        ArmorSlotRegistry.updateMap(this.byName);
    }

    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)INSTANCE);
    }

    @SubscribeEvent
    public static void syncPlaces(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            INSTANCE.syncToPlayer((ServerPlayer)event.getEntity());
        }
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            INSTANCE.syncToAll();
        }
    }

    private void syncToAll() {
        PacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateSlotReferences(this.byName));
    }

    private void syncToPlayer(ServerPlayer player) {
        PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateSlotReferences(this.byName));
    }
}

