/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.util;

import com.mrbysco.weightedinventory.registry.ArmorAttributeRegistry;
import java.util.EnumMap;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;

public class UnlockHelper {
    private static final EnumMap<EquipmentSlot, UUID> MODIFIER_PER_SLOT = (EnumMap)Util.m_137469_(new EnumMap(EquipmentSlot.class), map -> {
        map.put(EquipmentSlot.FEET, UUID.fromString("9E7A3709-84F7-46F7-9AEE-F38BE8D4BDFE"));
        map.put(EquipmentSlot.LEGS, UUID.fromString("A1E7F0F6-A94D-4D9F-BEA2-D41E93A16602"));
        map.put(EquipmentSlot.CHEST, UUID.fromString("97E368D8-2513-44D8-9EB9-4E120C10DB82"));
        map.put(EquipmentSlot.HEAD, UUID.fromString("E7FBD6E7-FF63-484D-B0BA-A06E21D30BDC"));
    });

    public static boolean isUnlocked(int index, int unlockedSlots) {
        if (unlockedSlots > 0) {
            return index - 9 < unlockedSlots;
        }
        return false;
    }

    public static int getUnlockedSlots(Player player) {
        AttributeInstance modifier = player.m_21051_((Attribute)ArmorAttributeRegistry.UNLOCKED.get());
        if (modifier != null) {
            return Mth.m_14045_((int)Mth.m_14107_((double)modifier.m_22135_()), (int)0, (int)27);
        }
        return 0;
    }

    public static int getUnlockedFreeSlot(Player player, NonNullList<ItemStack> items) {
        int unlockedCount = UnlockHelper.getUnlockedSlots(player) + 9;
        int slots = Mth.m_14045_((int)unlockedCount, (int)0, (int)items.size());
        if (slots == 0) {
            return -1;
        }
        for (int i = 0; i < slots; ++i) {
            if (!((ItemStack)items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public static AttributeModifier createModifier(EquipmentSlot slot, float slots) {
        return new AttributeModifier(MODIFIER_PER_SLOT.get(slot), "Unlocked Slots", (double)slots, AttributeModifier.Operation.ADDITION);
    }

    public static EquipmentSlot getEquipmentSlotForItem(ItemStack stack) {
        EquipmentSlot slot = stack.getEquipmentSlot();
        if (slot != null) {
            return slot;
        }
        Equipable equipable = Equipable.m_269088_((ItemStack)stack);
        if (equipable != null) {
            return equipable.m_40402_();
        }
        return EquipmentSlot.MAINHAND;
    }
}

