/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weightedinventory.handler;

import com.mrbysco.weightedinventory.registry.ArmorAttributeRegistry;
import com.mrbysco.weightedinventory.registry.ArmorSlotRegistry;
import com.mrbysco.weightedinventory.util.UnlockHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;

public class AttributeHandler {
    public static void addEntityAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, ArmorAttributeRegistry.UNLOCKED, 0.0);
    }

    public static void addItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack armorStack = event.getItemStack();
        EquipmentSlot slot = UnlockHelper.getEquipmentSlotForItem(armorStack);
        if (slot != null && slot != EquipmentSlot.OFFHAND && slot != EquipmentSlot.MAINHAND) {
            float slots = ArmorSlotRegistry.getSlots(armorStack);
            EquipmentSlotGroup equipmentslotgroup = EquipmentSlotGroup.bySlot((EquipmentSlot)slot);
            event.addModifier(ArmorAttributeRegistry.UNLOCKED, UnlockHelper.createModifier(slot, slots), equipmentslotgroup);
        }
    }
}

